/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.domain.model.dimension;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import monasca.common.model.domain.common.AbstractEntity;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class DimensionValues
extends AbstractEntity {
    protected String id = null;
    protected String dimensionName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String metricName;
    protected List<String> values;
    protected Map<String, List<String>> dimensionValues;

    public DimensionValues() {
        this.values = new ArrayList<String>();
        this.dimensionValues = new HashMap<String, List<String>>();
    }

    public DimensionValues(String metricName, String dimensionName, List<String> values) {
        this.metricName = metricName;
        this.dimensionName = dimensionName;
        this.values = values;
        this.dimensionValues = new HashMap<String, List<String>>();
        this.dimensionValues.put(dimensionName, values);
        this.id = this.generateId();
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getId() {
        if (null == this.id) {
            this.id = this.generateId();
        }
        return this.id;
    }

    private String generateId() {
        String hashstr = "metricName=" + this.metricName + "dimensionName=" + this.dimensionName;
        byte[] sha1Hash = DigestUtils.sha((String)hashstr);
        return Hex.encodeHexString((byte[])sha1Hash);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DimensionValues other = (DimensionValues)((Object)obj);
        if (this.dimensionName == null ? other.dimensionName != null : !this.dimensionName.equals(other.dimensionName)) {
            return false;
        }
        if (this.metricName == null ? other.metricName != null : !this.metricName.equals(other.metricName)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dimensionName == null ? 0 : this.dimensionName.hashCode());
        result = 31 * result + (this.metricName == null ? 0 : this.metricName.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public String toString() {
        return String.format("MetricName=%s DimensionValues [name=%s, values=%s]", this.metricName, this.dimensionName, this.values);
    }
}

