/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.domain.model.alarm;

import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import monasca.api.domain.model.common.Link;
import monasca.api.domain.model.common.Linked;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.domain.common.AbstractEntity;
import monasca.common.model.metric.MetricDefinition;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;

@XmlRootElement(name="Alarm")
public class Alarm
extends AbstractEntity
implements Linked {
    private List<Link> links;
    private List<MetricDefinition> metrics;
    private AlarmState state;
    private String lifecycleState;
    private String link;
    private AlarmDefinitionShort alarmDefinition;
    private DateTime stateUpdatedTimestamp;
    private DateTime updatedTimestamp;
    private DateTime createdTimestamp;

    public Alarm() {
    }

    public Alarm(String id, String alarmDefinitionId, String alarmDefinitionName, String alarmDefinitionSeverity, List<MetricDefinition> metrics, AlarmState state, String lifecycleState, String link, DateTime stateUpdatedTimestamp, DateTime updatedTimestamp, DateTime createdTimestamp) {
        this.id = id;
        this.setMetrics(metrics);
        this.setState(state);
        this.setLifecycleState(lifecycleState);
        this.setLink(link);
        this.setStateUpdatedTimestamp(stateUpdatedTimestamp);
        this.setUpdatedTimestamp(updatedTimestamp);
        this.setCreatedTimestamp(createdTimestamp);
        this.alarmDefinition = new AlarmDefinitionShort(alarmDefinitionId, alarmDefinitionName, alarmDefinitionSeverity);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public List<Link> getLinks() {
        return this.links;
    }

    public AlarmState getState() {
        return this.state;
    }

    public String getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLink() {
        return this.link;
    }

    public DateTime getStateUpdatedTimestamp() {
        return this.stateUpdatedTimestamp;
    }

    public DateTime getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    public DateTime getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @XmlElement(name="id")
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public void setState(AlarmState state) {
        this.state = state;
    }

    public void setLifecycleState(String lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setStateUpdatedTimestamp(DateTime stateUpdatedTimestamp) {
        this.stateUpdatedTimestamp = stateUpdatedTimestamp;
    }

    public void setUpdatedTimestamp(DateTime updatedTimestamp) {
        this.updatedTimestamp = updatedTimestamp;
    }

    public void setCreatedTimestamp(DateTime createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    public List<MetricDefinition> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricDefinition> metrics) {
        this.metrics = metrics;
    }

    public AlarmDefinitionShort getAlarmDefinition() {
        return this.alarmDefinition;
    }

    public void setAlarmDefinition(AlarmDefinitionShort alarmDefinition) {
        this.alarmDefinition = alarmDefinition;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.alarmDefinition == null ? 0 : this.alarmDefinition.hashCode());
        result = 31 * result + (this.links == null ? 0 : this.links.hashCode());
        result = 31 * result + (this.metrics == null ? 0 : this.metrics.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.lifecycleState == null ? 0 : this.lifecycleState.hashCode());
        result = 31 * result + (this.link == null ? 0 : this.link.hashCode());
        result = 31 * result + (this.stateUpdatedTimestamp == null ? 0 : this.stateUpdatedTimestamp.hashCode());
        result = 31 * result + (this.updatedTimestamp == null ? 0 : this.updatedTimestamp.hashCode());
        result = 31 * result + (this.createdTimestamp == null ? 0 : this.createdTimestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Alarm other = (Alarm)obj;
        if (this.alarmDefinition == null ? other.alarmDefinition != null : !this.alarmDefinition.equals(other.alarmDefinition)) {
            return false;
        }
        if (this.links == null ? other.links != null : !this.links.equals(other.links)) {
            return false;
        }
        if (this.metrics == null ? other.metrics != null : !CollectionUtils.isEqualCollection(this.metrics, other.metrics)) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        if (this.lifecycleState == null ? other.lifecycleState != null : !this.lifecycleState.equals(other.lifecycleState)) {
            return false;
        }
        if (this.link == null ? other.link != null : !this.link.equals(other.link)) {
            return false;
        }
        if (this.stateUpdatedTimestamp != other.stateUpdatedTimestamp) {
            if (this.stateUpdatedTimestamp == null || other.stateUpdatedTimestamp == null) {
                return false;
            }
            if (this.stateUpdatedTimestamp.getMillis() != other.stateUpdatedTimestamp.getMillis()) {
                return false;
            }
        }
        if (this.updatedTimestamp != other.updatedTimestamp) {
            if (this.updatedTimestamp == null || other.updatedTimestamp == null) {
                return false;
            }
            if (this.updatedTimestamp.getMillis() != other.updatedTimestamp.getMillis()) {
                return false;
            }
        }
        if (this.createdTimestamp != other.createdTimestamp) {
            if (this.createdTimestamp == null || other.createdTimestamp == null) {
                return false;
            }
            if (this.createdTimestamp.getMillis() != other.createdTimestamp.getMillis()) {
                return false;
            }
        }
        return true;
    }

    public static class AlarmDefinitionShort
    extends AbstractEntity
    implements Linked {
        private String name;
        private String severity;
        private List<Link> links;

        public AlarmDefinitionShort() {
        }

        public AlarmDefinitionShort(String id, String name, String severity) {
            this.id = id;
            this.name = name;
            this.severity = severity;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSeverity() {
            return this.severity;
        }

        public void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public List<Link> getLinks() {
            return this.links;
        }

        @Override
        public void setLinks(List<Link> links) {
            this.links = links;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.links == null ? 0 : this.links.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AlarmDefinitionShort other = (AlarmDefinitionShort)obj;
            if (this.links == null ? other.links != null : !this.links.equals(other.links)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.severity == null ? other.severity != null : !this.severity.equals(other.severity));
        }
    }
}

