/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app.validation;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import monasca.api.app.validation.DimensionValidation;
import monasca.api.resource.exception.Exceptions;
import monasca.common.model.alarm.AlarmSeverity;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class Validation {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':').omitEmptyStrings().trimResults().limit(2);
    private static final Splitter SPACE_SPLITTER = Splitter.on((char)' ').omitEmptyStrings().trimResults();
    private static final Splitter VERTICAL_BAR_SPLITTER = Splitter.on((char)'|').omitEmptyStrings().trimResults();
    private static final Joiner SPACE_JOINER = Joiner.on((char)' ');
    private static final DateTimeFormatter ISO_8601_FORMATTER = ISODateTimeFormat.dateOptionalTimeParser().withZoneUTC();
    private static final List<String> VALID_STATISTICS = Arrays.asList("avg", "min", "max", "sum", "count");
    private static final List<String> VALID_ALARM_STATE = Arrays.asList("undetermined", "ok", "alarm");
    public static final String DEFAULT_ADMIN_ROLE = "monasca-admin";

    private Validation() {
    }

    public static <T extends Enum<T>> T parseAndValidate(Class<T> type, String value) throws JsonMappingException {
        for (Enum constant : (Enum[])type.getEnumConstants()) {
            if (!constant.name().equalsIgnoreCase(value)) continue;
            return (T)constant;
        }
        ArrayList<String> acceptedValues = new ArrayList<String>();
        for (Enum constant : (Enum[])type.getEnumConstants()) {
            acceptedValues.add(constant.name());
        }
        throw new JsonMappingException(String.format("%s was not one of %s", value, acceptedValues));
    }

    public static DateTime parseAndValidateDate(String date, String parameterName, boolean required) {
        if (Strings.isNullOrEmpty((String)date)) {
            if (required) {
                throw Exceptions.unprocessableEntity("%s is required", parameterName);
            }
            return null;
        }
        try {
            return ISO_8601_FORMATTER.parseDateTime(date);
        }
        catch (Exception e) {
            throw Exceptions.unprocessableEntity("%s (%s) must be an ISO 8601 formatted time", parameterName, date);
        }
    }

    public static Map<String, String> parseAndValidateDimensions(String dimensionsStr) {
        Validation.validateNotNullOrEmpty(dimensionsStr, "dimensions");
        HashMap<String, String> dimensions = new HashMap<String, String>();
        for (String dimensionStr : COMMA_SPLITTER.split((CharSequence)dimensionsStr)) {
            String[] dimensionArr = (String[])Iterables.toArray((Iterable)COLON_SPLITTER.split((CharSequence)dimensionStr), String.class);
            if (dimensionArr.length == 1) {
                DimensionValidation.validateName(dimensionArr[0]);
                dimensions.put(dimensionArr[0], "");
                continue;
            }
            if (dimensionArr.length <= 1) continue;
            DimensionValidation.validateName(dimensionArr[0]);
            if (dimensionArr[1].contains("|")) {
                List dimensionValueArr = VERTICAL_BAR_SPLITTER.splitToList((CharSequence)dimensionArr[1]);
                for (String dimensionValue : dimensionValueArr) {
                    DimensionValidation.validateValue(dimensionValue, dimensionArr[0]);
                }
            } else {
                DimensionValidation.validateValue(dimensionArr[1], dimensionArr[0]);
            }
            dimensions.put(dimensionArr[0], dimensionArr[1]);
        }
        return dimensions;
    }

    public static int parseAndValidateNumber(String number, String parameterName) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            throw Exceptions.unprocessableEntity("%s (%s) must be valid number", parameterName, number);
        }
    }

    public static List<String> parseValidateAndNormalizeStatistics(Iterable<String> statistics) {
        ArrayList<String> validStats = new ArrayList<String>(5);
        for (String statistic : statistics) {
            String statisticLower = statistic.toLowerCase();
            if (!VALID_STATISTICS.contains(statisticLower)) {
                throw Exceptions.unprocessableEntity("%s is not a valid statistic", statistic);
            }
            validStats.add(statisticLower);
        }
        if (validStats.isEmpty()) {
            throw Exceptions.unprocessableEntity("Statistics are required", new Object[0]);
        }
        return validStats;
    }

    public static void validateAlarmState(String state) {
        String stateLower = state.toLowerCase();
        if (!VALID_ALARM_STATE.contains(stateLower)) {
            throw Exceptions.unprocessableEntity("%s is not a valid state", state);
        }
    }

    public static void validateNotNullOrEmpty(String value, String parameterName) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw Exceptions.unprocessableEntity("%s is required", parameterName);
        }
    }

    public static void validateTimes(DateTime startTime, DateTime endTime) {
        if (endTime != null && !startTime.isBefore((ReadableInstant)endTime)) {
            throw Exceptions.badRequest("start_time (%s) must be before end_time (%s)", startTime, endTime);
        }
    }

    public static Boolean validateAndParseMergeMetricsFlag(String mergeMetricsFlag) {
        if (mergeMetricsFlag == null) {
            return false;
        }
        if (!"true".equalsIgnoreCase(mergeMetricsFlag) && !"false".equalsIgnoreCase(mergeMetricsFlag)) {
            throw Exceptions.badRequest("merge_metrics must be either 'true' or 'false'", new Object[0]);
        }
        return Boolean.parseBoolean(mergeMetricsFlag);
    }

    public static void validateMetricsGroupBy(String groupBy) {
        if (!Strings.isNullOrEmpty((String)groupBy) && !"*".equals(groupBy)) {
            throw Exceptions.unprocessableEntity("Invalid group_by", "Group_by must be '*' if specified");
        }
    }

    public static void validateLifecycleState(String lifecycleState) {
        if (lifecycleState != null && lifecycleState.length() > 50) {
            throw Exceptions.unprocessableEntity("Lifecycle state '%s' must be 50 characters or less", lifecycleState);
        }
    }

    public static void validateLink(String link) {
        if (link != null && link.length() > 512) {
            throw Exceptions.unprocessableEntity("Link '%s' must be 512 characters or less", link);
        }
    }

    public static String getQueryProject(String roles, String crossTenantId, String tenantId, String admin_role) throws Exception {
        boolean isAdmin;
        String queryTenantId = tenantId;
        boolean bl = isAdmin = !Strings.isNullOrEmpty((String)roles) && COMMA_SPLITTER.splitToList((CharSequence)roles).contains(admin_role);
        if (Validation.isCrossProjectRequest(crossTenantId, tenantId)) {
            if (isAdmin) {
                queryTenantId = crossTenantId;
            } else {
                throw Exceptions.forbidden("Only users with %s role can GET cross tenant metrics", admin_role);
            }
        }
        return queryTenantId;
    }

    public static boolean isCrossProjectRequest(String crossTenantId, String tenantId) {
        return !Strings.isNullOrEmpty((String)crossTenantId) && !crossTenantId.equals(tenantId);
    }

    public static List<AlarmSeverity> parseAndValidateSeverity(String severityStr) {
        ArrayList<AlarmSeverity> severityList = null;
        if (severityStr != null && !severityStr.isEmpty()) {
            severityList = new ArrayList<AlarmSeverity>();
            ArrayList severities = Lists.newArrayList((Iterable)VERTICAL_BAR_SPLITTER.split((CharSequence)severityStr));
            for (String severity : severities) {
                AlarmSeverity s = AlarmSeverity.fromString((String)severity);
                if (s != null) {
                    severityList.add(s);
                    continue;
                }
                throw Exceptions.unprocessableEntity(String.format("Invalid severity %s", severity), new Object[0]);
            }
        }
        return severityList;
    }

    public static List<String> parseAndValidateSortBy(String sortBy, List<String> allowed_sort_by) {
        ArrayList<String> sortByList = new ArrayList<String>();
        if (sortBy != null && !sortBy.isEmpty()) {
            List fieldList = COMMA_SPLITTER.omitEmptyStrings().trimResults().splitToList((CharSequence)sortBy);
            for (String sortByField : fieldList) {
                ArrayList field = Lists.newArrayList((Iterable)SPACE_SPLITTER.split((CharSequence)sortByField.toLowerCase()));
                if (field.size() > 2) {
                    throw Exceptions.unprocessableEntity(String.format("Invalid sort_by format %s", sortByField), new Object[0]);
                }
                if (!allowed_sort_by.contains(field.get(0))) {
                    throw Exceptions.unprocessableEntity(String.format("Sort_by field %s must be one of %s", field.get(0), allowed_sort_by), new Object[0]);
                }
                if (field.size() > 1 && !((String)field.get(1)).equals("desc") && !((String)field.get(1)).equals("asc")) {
                    throw Exceptions.unprocessableEntity(String.format("Sort_by order %s must be 'asc' or 'desc'", field.get(1)), new Object[0]);
                }
                sortByList.add(SPACE_JOINER.join((Iterable)field));
            }
        }
        return sortByList;
    }
}

