/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app.validation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import monasca.api.app.validation.DimensionValidation;
import monasca.api.app.validation.MetricNameValidation;
import monasca.api.resource.exception.Exceptions;
import monasca.common.model.alarm.AlarmExpression;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.metric.MetricDefinition;

public final class AlarmValidation {
    private static final List<String> VALID_ALARM_SERVERITY = Arrays.asList("low", "medium", "high", "critical");

    private AlarmValidation() {
    }

    public static void validate(String name, String description, String severity, List<String> alarmActions, List<String> okActions, List<String> undeterminedActions) {
        if (name != null && name.length() > 255) {
            throw Exceptions.unprocessableEntity("Name %s must be 255 characters or less", name);
        }
        if (description != null && description.length() > 255) {
            throw Exceptions.unprocessableEntity("Description %s must be 255 characters or less", description);
        }
        if (alarmActions != null) {
            for (String action : alarmActions) {
                if (action.length() <= 50) continue;
                throw Exceptions.unprocessableEntity("Alarm action %s must be 50 characters or less", action);
            }
            if (AlarmValidation.checkForDuplicateNotificationMethodsInAlarmDef(alarmActions)) {
                throw Exceptions.unprocessableEntity("Alarm definition cannot have Duplicate alarm notification methods", new Object[0]);
            }
        }
        if (okActions != null) {
            for (String action : okActions) {
                if (action.length() <= 50) continue;
                throw Exceptions.unprocessableEntity("Ok action %s must be 50 characters or less", action);
            }
            if (AlarmValidation.checkForDuplicateNotificationMethodsInAlarmDef(okActions)) {
                throw Exceptions.unprocessableEntity("Alarm definition cannot have Duplicate OK notification methods", new Object[0]);
            }
        }
        if (undeterminedActions != null) {
            for (String action : undeterminedActions) {
                if (action.length() <= 50) continue;
                throw Exceptions.unprocessableEntity("Undetermined action %s must be 50 characters or less", action);
            }
            if (AlarmValidation.checkForDuplicateNotificationMethodsInAlarmDef(undeterminedActions)) {
                throw Exceptions.unprocessableEntity("Alarm definition cannot have Duplicate Undetermined notification methods", new Object[0]);
            }
        }
        if (severity != null && !VALID_ALARM_SERVERITY.contains(severity.toLowerCase())) {
            throw Exceptions.unprocessableEntity("%s is not a valid severity", severity);
        }
    }

    public static AlarmExpression validateNormalizeAndGet(String expression) {
        AlarmExpression alarmExpression = null;
        try {
            alarmExpression = AlarmExpression.of((String)expression);
        }
        catch (IllegalArgumentException e) {
            throw Exceptions.unprocessableEntityDetails("The alarm expression is invalid", e.getMessage(), e);
        }
        for (AlarmSubExpression subExpression : alarmExpression.getSubExpressions()) {
            MetricDefinition metricDef = subExpression.getMetricDefinition();
            metricDef.name = MetricNameValidation.normalize(metricDef.name);
            MetricNameValidation.validate(metricDef.name, true);
            if (metricDef.dimensions != null) {
                metricDef.setDimensions(DimensionValidation.normalize(metricDef.dimensions));
                DimensionValidation.validate(metricDef.dimensions);
            }
            if (subExpression.getPeriod() == 0) {
                throw Exceptions.unprocessableEntity("Period must not be 0", new Object[0]);
            }
            if (subExpression.getPeriod() % 60 != 0) {
                throw Exceptions.unprocessableEntity("Period %s must be a multiple of 60", subExpression.getPeriod());
            }
            if (subExpression.getPeriods() < 1) {
                throw Exceptions.unprocessableEntity("Periods %s must be greater than or equal to 1", subExpression.getPeriods());
            }
            if (subExpression.getPeriod() * subExpression.getPeriods() <= 1209600) continue;
            throw Exceptions.unprocessableEntity("Period %s times %s must total less than 2 weeks in seconds (1209600)", subExpression.getPeriod(), subExpression.getPeriods());
        }
        return alarmExpression;
    }

    private static boolean checkForDuplicateNotificationMethodsInAlarmDef(List<String> alarmActions) {
        HashSet<String> inputSet = new HashSet<String>(alarmActions);
        return inputSet.size() < alarmActions.size();
    }
}

