/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app.command;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import monasca.api.app.validation.NotificationMethodValidation;
import monasca.api.app.validation.Validation;
import org.hibernate.validator.constraints.NotEmpty;

public class CreateNotificationMethodCommand {
    @NotEmpty
    @Size(min=1, max=250)
    public String name;
    @NotNull
    public String type;
    @NotEmpty
    @Size(min=1, max=512)
    public String address;
    public String period;
    private int convertedPeriod = 0;

    public CreateNotificationMethodCommand() {
        this.period = "0";
    }

    public CreateNotificationMethodCommand(String name, String notificationMethodType, String address, String period) {
        this.name = name;
        this.type = notificationMethodType;
        this.address = address;
        period = period == null ? "0" : period;
        this.setPeriod(period);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateNotificationMethodCommand other = (CreateNotificationMethodCommand)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.period == null ? other.period != null : !this.period.equals(other.period)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equalsIgnoreCase(other.type)) {
            return false;
        }
        return this.convertedPeriod == other.convertedPeriod;
    }

    public void validate(List<Integer> validPeriods) {
        NotificationMethodValidation.validate(this.type, this.address, this.convertedPeriod, validPeriods);
    }

    public void setPeriod(String period) {
        this.period = period;
        this.convertedPeriod = Validation.parseAndValidateNumber(period, "period");
    }

    public void setType(String type) {
        this.type = type == null ? null : type.toUpperCase();
    }

    public int getConvertedPeriod() {
        return this.convertedPeriod;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.period == null ? 0 : this.period.hashCode());
        result = 31 * result + this.convertedPeriod;
        return result;
    }
}

