/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app.command;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import monasca.api.app.validation.DimensionValidation;
import monasca.api.app.validation.MetricNameValidation;
import monasca.api.app.validation.ValueMetaValidation;
import monasca.api.resource.exception.Exceptions;
import monasca.common.model.metric.Metric;
import org.hibernate.validator.constraints.NotEmpty;

public class CreateMetricCommand {
    private static final long TIME_2MIN_MILLIS = 120000L;
    private static final long TIME_2WEEKS_MILLIS = 1209600000L;
    public static final int MAX_NAME_LENGTH = 255;
    @NotEmpty
    @Size(min=1, max=255)
    public String name;
    public Map<String, String> dimensions;
    @NotNull
    public Long timestamp;
    @NotNull
    public Double value;
    public Map<String, String> valueMeta;

    public CreateMetricCommand() {
    }

    public CreateMetricCommand(String name, @Nullable Map<String, String> dimensions, long timestamp, double value, @Nullable Map<String, String> valueMeta) {
        this.setName(name);
        this.setDimensions(dimensions);
        this.timestamp = timestamp;
        this.setValueMeta(valueMeta);
        this.value = value;
    }

    private static void validateTimestamp(long timestamp) {
        long time = System.currentTimeMillis();
        if (timestamp > time + 120000L || timestamp < time - 1209600000L) {
            throw Exceptions.unprocessableEntity("Timestamp %s is out of legal range", timestamp);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateMetricCommand other = (CreateMetricCommand)obj;
        if (this.dimensions == null ? other.dimensions != null : !this.dimensions.equals(other.dimensions)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dimensions == null ? 0 : this.dimensions.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : (int)(this.timestamp ^ this.timestamp >>> 32));
        long temp = this.value == null ? 0L : Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @JsonProperty
    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions == null || dimensions.isEmpty() ? null : DimensionValidation.normalize(dimensions);
    }

    @JsonProperty
    public void setValueMeta(Map<String, String> valueMeta) {
        this.valueMeta = ValueMetaValidation.normalize(valueMeta);
    }

    @JsonProperty
    public void setName(String name) {
        this.name = MetricNameValidation.normalize(name);
    }

    public Metric toMetric() {
        return new Metric(this.name, this.dimensions, this.timestamp.longValue(), this.value.doubleValue(), this.valueMeta);
    }

    public void validate() {
        MetricNameValidation.validate(this.name, true);
        if (this.dimensions != null) {
            DimensionValidation.validate(this.dimensions);
        }
        if (this.valueMeta != null) {
            ValueMetaValidation.validate(this.valueMeta);
        }
        CreateMetricCommand.validateTimestamp(this.timestamp);
    }
}

