/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app;

import java.util.Map;
import javax.inject.Inject;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import monasca.api.ApiConfig;
import monasca.api.app.command.UpdateAlarmCommand;
import monasca.api.domain.exception.EntityNotFoundException;
import monasca.api.domain.model.alarm.Alarm;
import monasca.api.domain.model.alarm.AlarmRepo;
import monasca.api.domain.model.alarmdefinition.AlarmDefinition;
import monasca.api.domain.model.alarmdefinition.AlarmDefinitionRepo;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.event.AlarmDeletedEvent;
import monasca.common.model.event.AlarmStateTransitionedEvent;
import monasca.common.model.event.AlarmUpdatedEvent;
import monasca.common.util.Exceptions;
import monasca.common.util.Serialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmService {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmService.class);
    private final ApiConfig config;
    private final Producer<String, String> producer;
    private final AlarmRepo repo;
    private final AlarmDefinitionRepo alarmDefRepo;
    private long messageCount = 0L;

    @Inject
    public AlarmService(ApiConfig config, Producer<String, String> producer, AlarmRepo repo, AlarmDefinitionRepo alarmDefRepo) {
        this.config = config;
        this.producer = producer;
        this.repo = repo;
        this.alarmDefRepo = alarmDefRepo;
    }

    public void delete(String tenantId, String alarmId) {
        Alarm alarm = this.repo.findById(tenantId, alarmId);
        Map<String, AlarmSubExpression> subAlarmMetricDefs = this.repo.findAlarmSubExpressions(alarmId);
        this.repo.deleteById(tenantId, alarmId);
        String event = Serialization.toJson((Object)new AlarmDeletedEvent(tenantId, alarmId, alarm.getMetrics(), alarm.getAlarmDefinition().getId(), subAlarmMetricDefs));
        this.producer.send(new KeyedMessage(this.config.eventsTopic, (Object)String.valueOf(this.messageCount++), (Object)event));
    }

    public Alarm patch(String tenantId, String alarmId, AlarmState state, String lifecycleState, String link) {
        Alarm oldAlarm = this.repo.findById(tenantId, alarmId);
        if (state == null && lifecycleState == null && link == null) {
            return oldAlarm;
        }
        state = state == null ? oldAlarm.getState() : state;
        lifecycleState = lifecycleState == null ? oldAlarm.getLifecycleState() : lifecycleState;
        link = link == null ? oldAlarm.getLink() : link;
        Alarm alarm = this.updateInternal(tenantId, alarmId, state, lifecycleState, link);
        return alarm;
    }

    public Alarm update(String tenantId, String alarmId, UpdateAlarmCommand command) {
        Alarm alarm = this.updateInternal(tenantId, alarmId, command.state, command.lifecycleState, command.link);
        return alarm;
    }

    private String stateChangeReasonFor(AlarmState oldState, AlarmState newState) {
        return "Alarm state updated via API";
    }

    private Alarm updateInternal(String tenantId, String alarmId, AlarmState newState, String newLifecycleState, String newLink) {
        try {
            LOG.debug("Updating alarm {} for tenant {}", (Object)alarmId, (Object)tenantId);
            Alarm alarm = this.repo.update(tenantId, alarmId, newState, newLifecycleState, newLink);
            AlarmState oldState = alarm.getState();
            AlarmDefinition alarmDef = this.alarmDefRepo.findById(tenantId, alarm.getAlarmDefinition().getId());
            Map<String, AlarmSubExpression> subAlarms = this.repo.findAlarmSubExpressions(alarmId);
            String event = Serialization.toJson((Object)new AlarmUpdatedEvent(alarmId, alarmDef.getId(), tenantId, alarm.getMetrics(), subAlarms, newState, oldState, newLink, newLifecycleState));
            this.producer.send(new KeyedMessage(this.config.eventsTopic, (Object)String.valueOf(this.messageCount++), (Object)event));
            if (!oldState.equals((Object)newState)) {
                event = Serialization.toJson((Object)new AlarmStateTransitionedEvent(tenantId, alarmId, alarmDef.getId(), alarm.getMetrics(), alarmDef.getName(), alarmDef.getDescription(), oldState, newState, alarmDef.getSeverity(), newLink, newLifecycleState, alarmDef.isActionsEnabled(), this.stateChangeReasonFor(oldState, newState), null, System.currentTimeMillis()));
                this.producer.send(new KeyedMessage(this.config.alarmStateTransitionsTopic, (Object)String.valueOf(this.messageCount++), (Object)event));
            }
            alarm.setState(newState);
            alarm.setLifecycleState(newLifecycleState);
            alarm.setLink(newLink);
            return alarm;
        }
        catch (EntityNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Exception)e, (String)"Error updating alarm for project / tenant %s", (Object[])new Object[]{tenantId});
        }
    }
}

