/*
 * Decompiled with CFR 0.152.
 */
package monasca.api;

import ch.qos.logback.classic.Level;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Joiner;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.name.Names;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import kafka.javaapi.producer.Producer;
import kafka.producer.ProducerConfig;
import monasca.api.ApiConfig;
import monasca.api.app.ApplicationModule;
import monasca.api.domain.DomainModule;
import monasca.api.infrastructure.InfrastructureModule;
import monasca.common.hibernate.db.AlarmActionDb;
import monasca.common.hibernate.db.AlarmActionId;
import monasca.common.hibernate.db.AlarmDb;
import monasca.common.hibernate.db.AlarmDefinitionDb;
import monasca.common.hibernate.db.AlarmMetricDb;
import monasca.common.hibernate.db.AlarmMetricId;
import monasca.common.hibernate.db.MetricDefinitionDb;
import monasca.common.hibernate.db.MetricDefinitionDimensionsDb;
import monasca.common.hibernate.db.MetricDimensionDb;
import monasca.common.hibernate.db.NotificationMethodDb;
import monasca.common.hibernate.db.NotificationMethodTypesDb;
import monasca.common.hibernate.db.SubAlarmDb;
import monasca.common.hibernate.db.SubAlarmDefinitionDb;
import monasca.common.hibernate.db.SubAlarmDefinitionDimensionDb;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.skife.jdbi.v2.DBI;

public class MonApiModule
extends AbstractModule {
    private static final String POSTGRES_DS_CLASS = "org.postgresql.ds.PGPoolingDataSource";
    private static final String MYSQL_DS_CLASS = "com.mysql.jdbc.jdbc2.optional.MysqlDataSource";
    private final ApiConfig config;
    private final Environment environment;

    public MonApiModule(Environment environment, ApiConfig config) {
        this.environment = environment;
        this.config = config;
    }

    protected void configure() {
        this.bind(ApiConfig.class).toInstance((Object)this.config);
        this.bind(MetricRegistry.class).toInstance((Object)this.environment.metrics());
        if (!this.isHibernateEnabled()) {
            this.bind(DataSourceFactory.class).annotatedWith((Annotation)Names.named((String)"mysql")).toInstance((Object)this.config.mysql);
        }
        this.bind(DataSourceFactory.class).annotatedWith((Annotation)Names.named((String)"vertica")).toInstance((Object)this.config.vertica);
        this.install((Module)new ApplicationModule());
        this.install((Module)new DomainModule());
        this.install((Module)new InfrastructureModule(this.config));
    }

    @Provides
    @Singleton
    @Named(value="orm")
    public SessionFactory getSessionFactory() {
        if (this.config.hibernate == null) {
            throw new ProvisionException("Unable to provision ORM DBI, couldn't locate hibernate configuration");
        }
        try {
            Configuration configuration = new Configuration();
            configuration.addAnnotatedClass(AlarmDb.class);
            configuration.addAnnotatedClass(AlarmActionDb.class);
            configuration.addAnnotatedClass(AlarmActionId.class);
            configuration.addAnnotatedClass(AlarmDefinitionDb.class);
            configuration.addAnnotatedClass(AlarmMetricDb.class);
            configuration.addAnnotatedClass(AlarmMetricId.class);
            configuration.addAnnotatedClass(MetricDefinitionDb.class);
            configuration.addAnnotatedClass(MetricDefinitionDimensionsDb.class);
            configuration.addAnnotatedClass(MetricDimensionDb.class);
            configuration.addAnnotatedClass(SubAlarmDefinitionDb.class);
            configuration.addAnnotatedClass(SubAlarmDefinitionDimensionDb.class);
            configuration.addAnnotatedClass(SubAlarmDb.class);
            configuration.addAnnotatedClass(NotificationMethodDb.class);
            configuration.addAnnotatedClass(NotificationMethodTypesDb.class);
            configuration.setProperties(this.getORMProperties(this.config.hibernate.getDataSourceClassName()));
            StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).build();
            return configuration.buildSessionFactory((ServiceRegistry)serviceRegistry);
        }
        catch (Throwable ex) {
            throw new ProvisionException("Failed to provision ORM DBI", ex);
        }
    }

    @Provides
    @Singleton
    @Named(value="mysql")
    public DBI getMySqlDBI() {
        try {
            return new DBIFactory().build(this.environment, this.config.mysql, "mysql");
        }
        catch (ClassNotFoundException e) {
            throw new ProvisionException("Failed to provision MySQL DBI", (Throwable)e);
        }
    }

    @Provides
    @Singleton
    @Named(value="vertica")
    public DBI getVerticaDBI() {
        try {
            return new DBIFactory().build(this.environment, (DataSourceFactory)this.config.vertica, "vertica");
        }
        catch (ClassNotFoundException e) {
            throw new ProvisionException("Failed to provision Vertica DBI", (Throwable)e);
        }
    }

    @Provides
    @Singleton
    public Producer<String, String> getProducer() {
        Properties props = new Properties();
        props.put("metadata.broker.list", Joiner.on((char)',').join((Object[])this.config.kafka.brokerUris));
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        props.put("request.required.acks", "1");
        ProducerConfig config = new ProducerConfig(props);
        return new Producer(config);
    }

    private Properties getORMProperties(String dataSourceClassName) {
        Properties properties = new Properties();
        switch (dataSourceClassName) {
            case "org.postgresql.ds.PGPoolingDataSource": {
                this.handlePostgresORMProperties(properties);
                break;
            }
            case "com.mysql.jdbc.jdbc2.optional.MysqlDataSource": {
                this.handleMySQLORMProperties(properties);
                break;
            }
            default: {
                throw new ProvisionException(String.format("%s is not supported, valid data sources are %s", dataSourceClassName, Arrays.asList(POSTGRES_DS_CLASS, MYSQL_DS_CLASS)));
            }
        }
        this.handleCommonORMProperties(properties);
        return properties;
    }

    private void handleCommonORMProperties(Properties properties) {
        properties.put("hibernate.connection.provider_class", this.config.hibernate.getProviderClass());
        properties.put("hibernate.hbm2ddl.auto", this.config.hibernate.getAutoConfig());
        properties.put("show_sql", (Object)this.config.getLoggingFactory().getLevel().equals(Level.DEBUG));
        properties.put("hibernate.hikari.dataSource.user", this.config.hibernate.getUser());
        properties.put("hibernate.hikari.dataSource.password", this.config.hibernate.getPassword());
        properties.put("hibernate.hikari.dataSourceClassName", this.config.hibernate.getDataSourceClassName());
    }

    private void handleMySQLORMProperties(Properties properties) {
        properties.put("hibernate.hikari.dataSource.url", this.config.hibernate.getDataSourceUrl());
    }

    private void handlePostgresORMProperties(Properties properties) {
        properties.put("hibernate.hikari.dataSource.serverName", this.config.hibernate.getServerName());
        properties.put("hibernate.hikari.dataSource.portNumber", this.config.hibernate.getPortNumber());
        properties.put("hibernate.hikari.dataSource.databaseName", this.config.hibernate.getDatabaseName());
        properties.put("hibernate.hikari.dataSource.initialConnections", this.config.hibernate.getInitialConnections());
        properties.put("hibernate.hikari.dataSource.maxConnections", this.config.hibernate.getMaxConnections());
        properties.put("hibernate.hikari.connectionTestQuery", "SELECT 1");
        properties.put("hibernate.hikari.connectionTimeout", "5000");
        properties.put("hibernate.hikari.initializationFailFast", "false");
    }

    private boolean isHibernateEnabled() {
        return this.config.hibernate != null && this.config.hibernate.getSupportEnabled();
    }
}

