/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource.exception;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import monasca.api.resource.exception.Exceptions;

@Provider
public class JsonProcessingExceptionMapper
implements ExceptionMapper<JsonProcessingException> {
    public Response toResponse(JsonProcessingException exception) {
        if (exception instanceof JsonGenerationException) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").entity((Object)Exceptions.buildLoggedErrorMessage(Exceptions.FaultType.SERVER_ERROR, "Error generating JSON", null, (Throwable)exception)).build();
        }
        String message = exception.getMessage();
        if (message.startsWith("No suitable constructor found")) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").entity((Object)Exceptions.buildLoggedErrorMessage(Exceptions.FaultType.SERVER_ERROR, "Unable to deserialize the provided JSON", null, (Throwable)exception)).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity((Object)Exceptions.buildLoggedErrorMessage(Exceptions.FaultType.BAD_REQUEST, "Unable to process the provided JSON", Exceptions.stripLocationFromStacktrace(message), (Throwable)exception)).build();
    }
}

