/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import monasca.api.app.MetricService;
import monasca.api.app.command.CreateMetricCommand;
import monasca.api.app.validation.Validation;
import monasca.api.domain.model.metric.MetricDefinitionRepository;
import monasca.api.resource.Links;
import monasca.api.resource.exception.Exceptions;
import monasca.common.model.Services;
import monasca.common.model.metric.Metric;

@Path(value="/v2.0/metrics")
public class MetricResource {
    private static final String MONITORING_DELEGATE_ROLE = "monitoring-delegate";
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private final MetricService service;
    private final MetricDefinitionRepository metricRepo;

    @Inject
    public MetricResource(MetricService service, MetricDefinitionRepository metricRepo) {
        this.service = service;
        this.metricRepo = metricRepo;
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    public void create(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @HeaderParam(value="X-Roles") String roles, @QueryParam(value="tenant_id") String crossTenantId, @Valid CreateMetricCommand[] commands) {
        boolean isDelegate = !Strings.isNullOrEmpty((String)roles) && COMMA_SPLITTER.splitToList((CharSequence)roles).contains(MONITORING_DELEGATE_ROLE);
        ArrayList<Metric> metrics = new ArrayList<Metric>(commands.length);
        for (CreateMetricCommand command : commands) {
            if (!isDelegate) {
                String service;
                if (command.dimensions != null && (service = command.dimensions.get("service")) != null && Services.isReserved((String)service)) {
                    throw Exceptions.forbidden("Project %s cannot POST metrics for the hpcs service", tenantId);
                }
                if (!Strings.isNullOrEmpty((String)crossTenantId)) {
                    throw Exceptions.forbidden("Project %s cannot POST cross tenant metrics", tenantId);
                }
            }
            command.validate();
            metrics.add(command.toMetric());
        }
        this.service.create(metrics, tenantId, crossTenantId);
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public Object getMetrics(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @QueryParam(value="name") String name, @QueryParam(value="dimensions") String dimensionsStr, @QueryParam(value="offset") String offset) throws Exception {
        Map<String, String> dimensions = Strings.isNullOrEmpty((String)dimensionsStr) ? null : Validation.parseAndValidateNameAndDimensions(name, dimensionsStr);
        return Links.paginate(offset, this.metricRepo.find(tenantId, name, dimensions, offset), uriInfo);
    }
}

