/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Strings;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import monasca.api.app.validation.Validation;
import monasca.api.domain.model.common.Paged;
import monasca.api.domain.model.measurement.MeasurementRepository;
import monasca.api.domain.model.measurement.Measurements;
import monasca.api.resource.Links;
import org.joda.time.DateTime;

@Path(value="/v2.0/metrics/measurements")
public class MeasurementResource {
    private final MeasurementRepository repo;

    @Inject
    public MeasurementResource(MeasurementRepository repo) {
        this.repo = repo;
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public Object get(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @QueryParam(value="name") String name, @QueryParam(value="dimensions") String dimensionsStr, @QueryParam(value="start_time") String startTimeStr, @QueryParam(value="end_time") String endTimeStr, @QueryParam(value="offset") String offset) throws Exception {
        DateTime startTime = Validation.parseAndValidateDate(startTimeStr, "start_time", true);
        DateTime endTime = Validation.parseAndValidateDate(endTimeStr, "end_time", false);
        Validation.validateTimes(startTime, endTime);
        Map<String, String> dimensions = Strings.isNullOrEmpty((String)dimensionsStr) ? null : Validation.parseAndValidateNameAndDimensions(name, dimensionsStr);
        List<Measurements> measurementsList = this.repo.find(tenantId, name, dimensions, startTime, endTime, offset);
        LinkedList pagedList = new LinkedList();
        for (Measurements measurements : measurementsList) {
            pagedList.add(Links.paginateMeasurements(offset, measurements, uriInfo));
        }
        if (offset != null) {
            Paged paged = new Paged();
            paged.elements = pagedList;
            return paged;
        }
        return pagedList;
    }
}

