/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import monasca.api.MonApiConfiguration;
import monasca.api.domain.model.common.Link;
import monasca.api.domain.model.common.Linked;
import monasca.api.domain.model.common.Paged;
import monasca.api.domain.model.measurement.Measurements;
import monasca.common.model.domain.common.AbstractEntity;
import monasca.common.util.Injector;

public final class Links {
    static boolean accessedViaHttps;

    public static <T extends AbstractEntity> List<T> hydrate(List<T> resources, UriInfo uriInfo, String ... children) {
        Preconditions.checkNotNull(resources, (Object)"resources");
        String absolutePath = Links.prefixForHttps(uriInfo.getAbsolutePath().toString());
        for (AbstractEntity resource : resources) {
            Links.hydrate(resource, absolutePath, false, children);
        }
        return resources;
    }

    public static <T extends AbstractEntity> T hydrate(T resource, UriInfo uriInfo) {
        return Links.hydrate(resource, Links.prefixForHttps(uriInfo.getAbsolutePath().toString()), false, new String[0]);
    }

    public static <T extends AbstractEntity> T hydrate(T resource, UriInfo uriInfo, String resourcePath) {
        return Links.hydrate(resource, Links.concatPaths(uriInfo.getBaseUri().toString(), resourcePath) + "/", false, new String[0]);
    }

    private static String concatPaths(String first, String second) {
        if ((first.isEmpty() || first.endsWith("/")) && !second.isEmpty() && second.startsWith("/")) {
            return first + second.substring(1);
        }
        return first + second;
    }

    public static <T extends AbstractEntity> T hydrate(T resource, UriInfo uriInfo, boolean uriInfoForSpecificResource, String ... children) {
        return Links.hydrate(resource, Links.prefixForHttps(uriInfo.getAbsolutePath().toString()), uriInfoForSpecificResource, children);
    }

    static String prefixForHttps(String path) {
        if (accessedViaHttps && !path.toLowerCase().startsWith("https")) {
            path = "https" + path.substring(path.indexOf("://"));
        }
        return path;
    }

    private static <T extends AbstractEntity> T hydrate(T resource, String path, boolean pathForSpecificResource, String ... children) {
        Preconditions.checkNotNull(resource, (Object)"resource");
        ArrayList<Link> links = new ArrayList<Link>(children.length + 1);
        if (!pathForSpecificResource) {
            boolean pathEndsInSlash;
            boolean bl = pathEndsInSlash = path.length() > 0 && path.charAt(path.length() - 1) == '/';
            if (!pathEndsInSlash) {
                path = path + "/";
            }
            path = path + resource.getId();
        }
        links.add(new Link("self", path));
        for (String child : children) {
            links.add(new Link(child, path + "/" + child));
        }
        ((Linked)resource).setLinks(links);
        return resource;
    }

    public static Object paginate(String offset, List<? extends AbstractEntity> elements, UriInfo uriInfo) {
        if (offset != null) {
            Paged paged = new Paged();
            Link selfLink = new Link();
            selfLink.rel = "self";
            selfLink.href = uriInfo.getRequestUri().toString();
            paged.links.add(selfLink);
            if (elements != null && elements.size() >= 50) {
                Link nextLink = new Link();
                nextLink.rel = "next";
                nextLink.href = uriInfo.getAbsolutePath().toString() + "?offset=" + ((AbstractEntity)elements.get(elements.size() - 1)).getId();
                for (String parmKey : uriInfo.getQueryParameters().keySet()) {
                    if (parmKey.equalsIgnoreCase("offset")) continue;
                    List parmValList = (List)uriInfo.getQueryParameters().get((Object)parmKey);
                    for (String parmVal : parmValList) {
                        nextLink.href = nextLink.href + "&" + parmKey + "=" + parmVal;
                    }
                }
                paged.links.add(nextLink);
            }
            paged.elements = elements != null ? elements : new ArrayList();
            return paged;
        }
        return elements;
    }

    public static Object paginateMeasurements(String offset, Measurements measurements, UriInfo uriInfo) throws UnsupportedEncodingException {
        if (offset != null) {
            Paged paged = new Paged();
            Link selfLink = new Link();
            selfLink.rel = "self";
            selfLink.href = uriInfo.getRequestUri().toString();
            paged.links.add(selfLink);
            if (measurements.getMeasurements().size() >= 50) {
                Link nextLink = new Link();
                nextLink.rel = "next";
                nextLink.href = uriInfo.getAbsolutePath().toString() + "?offset=" + measurements.getId();
                for (String parmKey : uriInfo.getQueryParameters().keySet()) {
                    if (parmKey.equalsIgnoreCase("offset") || parmKey.equalsIgnoreCase("dimensions")) continue;
                    List parmValList = (List)uriInfo.getQueryParameters().get((Object)parmKey);
                    for (String parmVal : parmValList) {
                        nextLink.href = nextLink.href + "&" + parmKey + "=" + parmVal;
                    }
                }
                Map<String, String> dimensionsMap = measurements.getDimensions();
                if (dimensionsMap != null && !dimensionsMap.isEmpty()) {
                    nextLink.href = nextLink.href + "&dimensions=";
                    boolean firstDimension = true;
                    for (String dimensionKey : dimensionsMap.keySet()) {
                        String dimensionVal = dimensionsMap.get(dimensionKey);
                        if (firstDimension) {
                            firstDimension = false;
                        } else {
                            nextLink.href = nextLink.href + URLEncoder.encode(",", "UTF-8");
                        }
                        nextLink.href = nextLink.href + dimensionKey + URLEncoder.encode(":", "UTF-8") + dimensionVal;
                    }
                }
                paged.links.add(nextLink);
            }
            ArrayList measurementsList = new ArrayList();
            measurementsList.add(measurements);
            paged.elements = measurementsList;
            return paged;
        }
        return measurements;
    }

    static {
        MonApiConfiguration config = (MonApiConfiguration)((Object)Injector.getInstance(MonApiConfiguration.class));
        if (config != null && config.accessedViaHttps != null) {
            accessedViaHttps = config.accessedViaHttps;
        }
    }
}

