/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.servlet;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import monasca.api.resource.exception.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleAuthorizationFilter
implements ContainerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(ContainerRequestFilter.class);
    @Context
    private HttpServletRequest httpServletRequest;
    private static final String VALID_MONASCA_AGENT_PATH = "/v2.0/metrics";

    public ContainerRequest filter(ContainerRequest containerRequest) {
        String method = containerRequest.getMethod();
        Object isAgent = this.httpServletRequest.getAttribute("X-MONASCA_AGENT");
        String pathInfo = this.httpServletRequest.getPathInfo();
        if (!(isAgent == null || pathInfo.equals(VALID_MONASCA_AGENT_PATH) && method.equals("POST"))) {
            logger.warn("User {} is missing a required role to {} on {}", new Object[]{this.httpServletRequest.getAttribute("X-USER-NAME"), method, pathInfo});
            throw Exceptions.badRequest("User is missing a required role to perform this request", new Object[0]);
        }
        return containerRequest;
    }
}

