/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.vertica;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.domain.model.alarmstatehistory.AlarmStateHistory;
import monasca.api.domain.model.alarmstatehistory.AlarmStateHistoryRepository;
import monasca.api.infrastructure.persistence.DimensionQueries;
import monasca.api.infrastructure.persistence.SubAlarmQueries;
import monasca.common.persistence.BeanMapper;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class AlarmStateHistoryVerticaRepositoryImpl
implements AlarmStateHistoryRepository {
    public static final DateTimeFormatter DATETIME_FORMATTER = ISODateTimeFormat.dateTimeNoMillis().withZoneUTC();
    private static final String FIND_ALARMS_SQL = "select distinct ad.id from alarm_definition as ad join sub_alarm_definition sad on ad.id = sad.alarm_definition_id left outer join sub_alarm_definition_dimension dim on sad.id = dim.sub_alarm_definition_id%s where ad.tenant_id = :tenantId and ad.deleted_at is NULL";
    private static final String FIND_BY_ALARM_DEF_SQL = "select *, time_stamp as timestamp from MonAlarms.StateHistory where tenant_id = :tenantId%s order by time_stamp desc";
    private final DBI mysql;
    private final DBI vertica;

    @Inject
    public AlarmStateHistoryVerticaRepositoryImpl(@Named(value="mysql") DBI mysql, @Named(value="vertica") DBI vertica) {
        this.mysql = mysql;
        this.vertica = vertica;
    }

    @Override
    public List<AlarmStateHistory> findById(String tenantId, String alarmId, String offset) {
        try (Handle h = this.vertica.open();){
            List list = ((Query)((Query)h.createQuery("select alarm_id, old_state, new_state, reason, reason_data, time_stamp as timestamp from MonAlarms.StateHistory where tenant_id = :tenantId and alarm_id = :alarmId order by time_stamp desc").bind("tenantId", tenantId)).bind("alarmId", alarmId)).map((ResultSetMapper)new BeanMapper(AlarmStateHistory.class)).list();
            return list;
        }
    }

    @Override
    public List<AlarmStateHistory> find(String tenantId, Map<String, String> dimensions, DateTime startTime, @Nullable DateTime endTime, @Nullable String offset) {
        List alarmIds = null;
        try (Handle h = this.mysql.open();){
            String sql = String.format(FIND_ALARMS_SQL, SubAlarmQueries.buildJoinClauseFor(dimensions));
            Query query = (Query)h.createQuery(sql).bind("tenantId", tenantId);
            DimensionQueries.bindDimensionsToQuery(query, dimensions);
            alarmIds = query.map((ResultSetMapper)StringMapper.FIRST).list();
        }
        if (alarmIds == null || alarmIds.isEmpty()) {
            return Collections.emptyList();
        }
        h = this.vertica.open();
        var8_8 = null;
        try {
            StringBuilder sbWhere = new StringBuilder();
            sbWhere.append(" and alarm_id in (");
            for (int i = 0; i < alarmIds.size(); ++i) {
                if (i > 0) {
                    sbWhere.append(", ");
                }
                sbWhere.append('\'').append((String)alarmIds.get(i)).append('\'');
            }
            sbWhere.append(')');
            if (startTime != null) {
                sbWhere.append(" and time_stamp >= :startTime");
            }
            if (endTime != null) {
                sbWhere.append(" and time_stamp <= :endTime");
            }
            String sql = String.format(FIND_BY_ALARM_DEF_SQL, sbWhere);
            Query query = (Query)h.createQuery(sql).bind("tenantId", tenantId);
            if (startTime != null) {
                query.bind("startTime", new Timestamp(startTime.getMillis()));
            }
            if (endTime != null) {
                query.bind("endTime", new Timestamp(endTime.getMillis()));
            }
            DimensionQueries.bindDimensionsToQuery(query, dimensions);
            List list = query.map((ResultSetMapper)new BeanMapper(AlarmStateHistory.class)).list();
            return list;
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (h != null) {
                if (var8_8 != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable x2) {
                        var8_8.addSuppressed(x2);
                    }
                } else {
                    h.close();
                }
            }
        }
    }
}

