/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.influxdb;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;

final class Utils {
    private static final Pattern serieNamePattern = Pattern.compile("^.+\\?.+&.+(&.+=.+)*$");
    static final String COULD_NOT_LOOK_UP_COLUMNS_EXC_MSG = "Couldn't look up columns";

    private Utils() {
    }

    static String buildSerieNameRegex(String tenantId, String region, String name, Map<String, String> dimensions) throws Exception {
        StringBuilder regex = new StringBuilder("^");
        regex.append(Utils.urlEncodeUTF8(tenantId));
        regex.append("\\?");
        regex.append(Utils.urlEncodeUTF8(region));
        if (name != null) {
            regex.append("&");
            regex.append(Utils.urlEncodeUTF8(name));
            regex.append("(&|$)");
        }
        if (dimensions != null && !dimensions.isEmpty()) {
            TreeSet<Dimension> dimSortedSet = Utils.buildSortedDimSet(dimensions);
            for (Dimension dim : dimSortedSet) {
                regex.append("(.*&)*");
                regex.append(Utils.urlEncodeUTF8(dim.name));
                regex.append("=");
                regex.append(Utils.urlEncodeUTF8(dim.value));
                regex.append("(&|$)");
            }
        }
        return regex.toString();
    }

    static String urlEncodeUTF8(String s) throws Exception {
        return URLEncoder.encode(s, "UTF-8");
    }

    static String urlDecodeUTF8(String s) throws UnsupportedEncodingException {
        return URLDecoder.decode(s, "UTF-8");
    }

    static TreeSet<Dimension> buildSortedDimSet(Map<String, String> dimMap) {
        TreeSet<Dimension> dimTreeSet = new TreeSet<Dimension>();
        for (String dimName : dimMap.keySet()) {
            Dimension dim = new Dimension(dimName, dimMap.get(dimName));
            dimTreeSet.add(dim);
        }
        return dimTreeSet;
    }

    static boolean isSerieMetricName(String serieName) {
        Matcher m = serieNamePattern.matcher(serieName);
        return m.matches();
    }

    public static String buildOffsetPart(String offset) {
        if (offset != null) {
            if (!offset.isEmpty()) {
                return " and time < " + offset + "ms limit " + 50;
            }
            return " limit 50";
        }
        return "";
    }

    static class SerieNameDecodeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SerieNameDecodeException(String s) {
            super(s);
        }
    }

    static class SerieNameDecoder {
        private final String serieName;
        private final String metricName;
        private final String tenantId;
        private final String region;
        private final Map<String, String> dimensions;

        SerieNameDecoder(String serieName) throws Exception {
            if (!Utils.isSerieMetricName(serieName)) {
                throw new SerieNameDecodeException("Serie name is not decodable: " + serieName);
            }
            this.serieName = serieName;
            this.tenantId = Utils.urlDecodeUTF8(serieName.substring(0, serieName.indexOf(63)));
            String rest = serieName.substring(serieName.indexOf(63) + 1);
            this.region = Utils.urlDecodeUTF8(rest.substring(0, rest.indexOf(38)));
            if ((rest = rest.substring(rest.indexOf(38) + 1)).contains("&")) {
                this.metricName = Utils.urlDecodeUTF8(rest.substring(0, rest.indexOf(38)));
                rest = rest.substring(rest.indexOf(38) + 1);
            } else {
                this.metricName = Utils.urlDecodeUTF8(rest);
                rest = null;
            }
            this.dimensions = new HashMap<String, String>();
            while (rest != null) {
                String nameValPair;
                if (rest.contains("&")) {
                    nameValPair = rest.substring(0, rest.indexOf(38));
                    rest = rest.substring(rest.indexOf(38) + 1);
                } else {
                    nameValPair = rest;
                    rest = null;
                }
                String dimName = Utils.urlDecodeUTF8(nameValPair.split("=")[0]);
                String dimVal = Utils.urlDecodeUTF8(nameValPair.split("=")[1]);
                this.dimensions.put(dimName, dimVal);
            }
        }

        public String getSerieName() {
            return this.serieName;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public String getRegion() {
            return this.region;
        }

        public Map<String, String> getDimensions() {
            return this.dimensions;
        }
    }

    static final class Dimension
    implements Comparable<Dimension> {
        final String name;
        final String value;

        private Dimension(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public int compareTo(Dimension o) {
            int nameCmp = String.CASE_INSENSITIVE_ORDER.compare(this.name, o.name);
            return nameCmp != 0 ? nameCmp : String.CASE_INSENSITIVE_ORDER.compare(this.value, o.value);
        }
    }

    static class WhereClauseBuilder {
        private WhereClauseBuilder() {
        }

        static String buildTimePart(DateTime startTime, DateTime endTime) {
            StringBuilder sb = new StringBuilder();
            if (startTime != null) {
                sb.append(String.format(" and time > %1$ds", startTime.getMillis() / 1000L));
            }
            if (endTime != null) {
                sb.append(String.format(" and time < %1$ds", endTime.getMillis() / 1000L));
            }
            return sb.toString();
        }
    }

    static class SQLSanitizer {
        private static final Pattern sqlUnsafePattern = Pattern.compile("^.*('|;)+.*$");

        private SQLSanitizer() {
        }

        static String sanitize(String taintedString) throws Exception {
            Matcher m = sqlUnsafePattern.matcher(taintedString);
            if (m.matches()) {
                throw new Exception(String.format("Input from user contains single quote ['] or semi-colon [;] characters[ %1$s ]", taintedString));
            }
            return taintedString;
        }
    }
}

