/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.influxdb;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import monasca.api.MonApiConfiguration;
import monasca.api.domain.model.metric.MetricDefinitionRepository;
import monasca.api.infrastructure.persistence.influxdb.Utils;
import monasca.common.model.metric.MetricDefinition;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Serie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricDefinitionInfluxDbRepositoryImpl
implements MetricDefinitionRepository {
    private static final Logger logger = LoggerFactory.getLogger(MetricDefinitionInfluxDbRepositoryImpl.class);
    private final MonApiConfiguration config;
    private final InfluxDB influxDB;

    @Inject
    public MetricDefinitionInfluxDbRepositoryImpl(MonApiConfiguration config, InfluxDB influxDB) {
        this.config = config;
        this.influxDB = influxDB;
    }

    @Override
    public List<MetricDefinition> find(String tenantId, String name, Map<String, String> dimensions, String offset) throws Exception {
        String serieNameRegex = Utils.buildSerieNameRegex(tenantId, this.config.region, name, dimensions);
        String query = String.format("list series /%1$s/", serieNameRegex);
        logger.debug("Query string: {}", (Object)query);
        List result = this.influxDB.Query(this.config.influxDB.getName(), query, TimeUnit.SECONDS);
        return this.buildMetricDefList(result, offset);
    }

    private List<MetricDefinition> buildMetricDefList(List<Serie> result, String offset) throws Exception {
        String decodedOffset = null;
        if (offset != null) {
            decodedOffset = Utils.urlDecodeUTF8(offset);
        }
        ArrayList<MetricDefinition> metricDefinitionList = new ArrayList<MetricDefinition>();
        for (Serie serie : result) {
            for (Map point : serie.getRows()) {
                Utils.SerieNameDecoder serieNameDecoder;
                String encodedMetricName = (String)point.get("name");
                if (offset != null && encodedMetricName.compareTo(decodedOffset) <= 0) continue;
                try {
                    serieNameDecoder = new Utils.SerieNameDecoder(encodedMetricName);
                }
                catch (Utils.SerieNameDecodeException e) {
                    logger.warn("Dropping series name that is not decodable: {}", point.get("name"), (Object)e);
                    continue;
                }
                MetricDefinition metricDefinition = new MetricDefinition(serieNameDecoder.getMetricName(), serieNameDecoder.getDimensions());
                metricDefinition.setId(Utils.urlEncodeUTF8(encodedMetricName));
                metricDefinitionList.add(metricDefinition);
                if (offset == null || metricDefinitionList.size() < 50) continue;
                return metricDefinitionList;
            }
        }
        return metricDefinitionList;
    }
}

