/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app.validation;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import monasca.api.app.validation.DimensionValidation;
import monasca.api.app.validation.MetricNameValidation;
import monasca.api.resource.exception.Exceptions;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class Validation {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':').omitEmptyStrings().trimResults().limit(2);
    private static final DateTimeFormatter ISO_8601_FORMATTER = ISODateTimeFormat.dateOptionalTimeParser().withZoneUTC();
    private static final List<String> VALID_STATISTICS = Arrays.asList("avg", "min", "max", "sum", "count");
    private static final List<String> VALID_ALARM_STATE = Arrays.asList("undetermined", "ok", "alarm");

    private Validation() {
    }

    public static <T extends Enum<T>> T parseAndValidate(Class<T> type, String value) throws JsonMappingException {
        for (Enum constant : (Enum[])type.getEnumConstants()) {
            if (!constant.name().equalsIgnoreCase(value)) continue;
            return (T)constant;
        }
        ArrayList<String> acceptedValues = new ArrayList<String>();
        for (Enum constant : (Enum[])type.getEnumConstants()) {
            acceptedValues.add(constant.name());
        }
        throw new JsonMappingException(String.format("%s was not one of %s", value, acceptedValues));
    }

    public static DateTime parseAndValidateDate(String date, String parameterName, boolean required) {
        if (Strings.isNullOrEmpty((String)date)) {
            if (required) {
                throw Exceptions.unprocessableEntity("%s is required", parameterName);
            }
            return null;
        }
        try {
            return ISO_8601_FORMATTER.parseDateTime(date);
        }
        catch (Exception e) {
            throw Exceptions.unprocessableEntity("%s must be an ISO 8601 formatted time", parameterName);
        }
    }

    public static Map<String, String> parseAndValidateNameAndDimensions(String name, String dimensionsStr) {
        Map<String, String> dimensions = Validation.parseAndValidateDimensions(dimensionsStr);
        String service = dimensions.get("service");
        MetricNameValidation.validate(name, service);
        return dimensions;
    }

    public static Map<String, String> parseAndValidateDimensions(String dimensionsStr) {
        Validation.validateNotNullOrEmpty(dimensionsStr, "dimensions");
        HashMap<String, String> dimensions = new HashMap<String, String>();
        for (String dimensionStr : COMMA_SPLITTER.split((CharSequence)dimensionsStr)) {
            String[] dimensionArr = (String[])Iterables.toArray((Iterable)COLON_SPLITTER.split((CharSequence)dimensionStr), String.class);
            if (dimensionArr.length != 2) continue;
            dimensions.put(dimensionArr[0], dimensionArr[1]);
        }
        String service = (String)dimensions.get("service");
        DimensionValidation.validate(dimensions, service);
        return dimensions;
    }

    public static int parseAndValidateNumber(String number, String parameterName) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            throw Exceptions.unprocessableEntity("%s must be valid number", parameterName);
        }
    }

    public static List<String> parseValidateAndNormalizeStatistics(Iterable<String> statistics) {
        ArrayList<String> validStats = new ArrayList<String>(5);
        for (String statistic : statistics) {
            String statisticLower = statistic.toLowerCase();
            if (!VALID_STATISTICS.contains(statisticLower)) {
                throw Exceptions.unprocessableEntity("%s is not a valid statistic", statistic);
            }
            validStats.add(statisticLower);
        }
        if (validStats.isEmpty()) {
            throw Exceptions.unprocessableEntity("Statistics are required", new Object[0]);
        }
        return validStats;
    }

    public static void validateAlarmState(String state) {
        String stateLower = state.toLowerCase();
        if (!VALID_ALARM_STATE.contains(stateLower)) {
            throw Exceptions.unprocessableEntity("%s is not a valid state", state);
        }
    }

    public static void validateNotNullOrEmpty(String value, String parameterName) {
        if (Strings.isNullOrEmpty((String)value)) {
            throw Exceptions.unprocessableEntity("%s is required", parameterName);
        }
    }

    public static void validateTimes(DateTime startTime, DateTime endTime) {
        if (!startTime.isBefore((ReadableInstant)endTime)) {
            throw Exceptions.badRequest("start_time must be before end_time", new Object[0]);
        }
    }
}

