/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app.command;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import monasca.api.domain.model.notificationmethod.NotificationMethodType;
import monasca.api.resource.exception.Exceptions;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.hibernate.validator.constraints.NotEmpty;

public class CreateNotificationMethodCommand {
    @NotEmpty
    @Size(min=1, max=250)
    public String name;
    @NotNull
    public NotificationMethodType type;
    @NotEmpty
    @Size(min=1, max=100)
    public String address;

    public CreateNotificationMethodCommand() {
    }

    public CreateNotificationMethodCommand(String name, NotificationMethodType type, String address) {
        this.name = name;
        this.type = type;
        this.address = address;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateNotificationMethodCommand other = (CreateNotificationMethodCommand)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    public void validate() {
        switch (this.type) {
            case EMAIL: {
                if (EmailValidator.getInstance((boolean)true).isValid(this.address)) break;
                throw Exceptions.unprocessableEntity("Address %s is not of correct format", this.address);
            }
            case WEBHOOK: {
                String[] schemes = new String[]{"http", "https"};
                UrlValidator urlValidator = new UrlValidator(schemes, 10L);
                if (urlValidator.isValid(this.address)) break;
                throw Exceptions.unprocessableEntity("Address %s is not of correct format", this.address);
            }
        }
    }
}

