/*
 * Decompiled with CFR 0.152.
 */
package monasca.api;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Joiner;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.name.Names;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import kafka.javaapi.producer.Producer;
import kafka.producer.ProducerConfig;
import monasca.api.MonApiConfiguration;
import monasca.api.app.ApplicationModule;
import monasca.api.domain.DomainModule;
import monasca.api.infrastructure.InfrastructureModule;
import org.skife.jdbi.v2.DBI;

public class MonApiModule
extends AbstractModule {
    private final MonApiConfiguration config;
    private final Environment environment;

    public MonApiModule(Environment environment, MonApiConfiguration config) {
        this.environment = environment;
        this.config = config;
    }

    protected void configure() {
        this.bind(MonApiConfiguration.class).toInstance((Object)this.config);
        this.bind(MetricRegistry.class).toInstance((Object)this.environment.metrics());
        this.bind(DataSourceFactory.class).annotatedWith((Annotation)Names.named((String)"mysql")).toInstance((Object)this.config.mysql);
        this.bind(DataSourceFactory.class).annotatedWith((Annotation)Names.named((String)"vertica")).toInstance((Object)this.config.vertica);
        this.install((Module)new ApplicationModule());
        this.install((Module)new DomainModule());
        this.install((Module)new InfrastructureModule(this.config));
    }

    @Provides
    @Singleton
    @Named(value="mysql")
    public DBI getMySqlDBI() {
        try {
            return new DBIFactory().build(this.environment, this.config.mysql, "mysql");
        }
        catch (ClassNotFoundException e) {
            throw new ProvisionException("Failed to provision MySQL DBI", (Throwable)e);
        }
    }

    @Provides
    @Singleton
    @Named(value="vertica")
    public DBI getVerticaDBI() {
        try {
            return new DBIFactory().build(this.environment, this.config.vertica, "vertica");
        }
        catch (ClassNotFoundException e) {
            throw new ProvisionException("Failed to provision Vertica DBI", (Throwable)e);
        }
    }

    @Provides
    @Singleton
    public Producer<String, String> getProducer() {
        Properties props = new Properties();
        props.put("metadata.broker.list", Joiner.on((char)',').join((Object[])this.config.kafka.brokerUris));
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        props.put("request.required.acks", "1");
        ProducerConfig config = new ProducerConfig(props);
        return new Producer(config);
    }
}

