/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import monasca.api.app.validation.Validation;
import monasca.api.domain.model.statistic.StatisticRepo;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.resource.Links;
import org.joda.time.DateTime;

@Path(value="/v2.0/metrics/statistics")
public class StatisticResource {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private final StatisticRepo repo;
    private final PersistUtils persistUtils;

    @Inject
    public StatisticResource(StatisticRepo repo, PersistUtils persistUtils) {
        this.repo = repo;
        this.persistUtils = persistUtils;
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public Object get(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @QueryParam(value="name") String name, @QueryParam(value="dimensions") String dimensionsStr, @QueryParam(value="start_time") String startTimeStr, @QueryParam(value="end_time") String endTimeStr, @QueryParam(value="statistics") String statisticsStr, @DefaultValue(value="300") @QueryParam(value="period") String periodStr, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit, @QueryParam(value="merge_metrics") Boolean mergeMetricsFlag) throws Exception {
        DateTime startTime = Validation.parseAndValidateDate(startTimeStr, "start_time", true);
        DateTime endTime = Validation.parseAndValidateDate(endTimeStr, "end_time", false);
        Validation.validateTimes(startTime, endTime);
        Validation.validateNotNullOrEmpty(statisticsStr, "statistics");
        int period = Validation.parseAndValidateNumber(periodStr, "period");
        List<String> statistics = Validation.parseValidateAndNormalizeStatistics(COMMA_SPLITTER.split((CharSequence)statisticsStr));
        Map<String, String> dimensions = Strings.isNullOrEmpty((String)dimensionsStr) ? null : Validation.parseAndValidateNameAndDimensions(name, dimensionsStr, true);
        return Links.paginateStatistics(this.persistUtils.getLimit(limit), this.repo.find(tenantId, name, dimensions, startTime, endTime, statistics, period, offset, this.persistUtils.getLimit(limit), mergeMetricsFlag), uriInfo);
    }
}

