/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Strings;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import monasca.api.app.validation.Validation;
import monasca.api.domain.model.measurement.MeasurementRepo;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.resource.Links;
import org.joda.time.DateTime;

@Path(value="/v2.0/metrics/measurements")
public class MeasurementResource {
    private final MeasurementRepo repo;
    private final PersistUtils persistUtils;

    @Inject
    public MeasurementResource(MeasurementRepo repo, PersistUtils persistUtils) {
        this.repo = repo;
        this.persistUtils = persistUtils;
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public Object get(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @QueryParam(value="name") String name, @QueryParam(value="dimensions") String dimensionsStr, @QueryParam(value="start_time") String startTimeStr, @QueryParam(value="end_time") String endTimeStr, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit, @QueryParam(value="merge_metrics") Boolean mergeMetricsFlag) throws Exception {
        DateTime startTime = Validation.parseAndValidateDate(startTimeStr, "start_time", true);
        DateTime endTime = Validation.parseAndValidateDate(endTimeStr, "end_time", false);
        Validation.validateTimes(startTime, endTime);
        Map<String, String> dimensions = Strings.isNullOrEmpty((String)dimensionsStr) ? null : Validation.parseAndValidateNameAndDimensions(name, dimensionsStr, true);
        return Links.paginateMeasurements(this.persistUtils.getLimit(limit), this.repo.find(tenantId, name, dimensions, startTime, endTime, offset, this.persistUtils.getLimit(limit), mergeMetricsFlag), uriInfo);
    }
}

