/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.vertica;

import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.domain.model.measurement.MeasurementRepo;
import monasca.api.domain.model.measurement.Measurements;
import monasca.api.infrastructure.persistence.DimensionQueries;
import monasca.api.infrastructure.persistence.vertica.MetricQueries;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;

public class MeasurementVerticaRepoImpl
implements MeasurementRepo {
    public static final DateTimeFormatter DATETIME_FORMATTER = ISODateTimeFormat.dateTimeNoMillis().withZoneUTC();
    private static final String FIND_BY_METRIC_DEF_SQL = "select def.name, m.definition_dimensions_id, dd.dimension_set_id, m.id, m.time_stamp, m.value from MonMetrics.Measurements m, MonMetrics.Definitions def, MonMetrics.DefinitionDimensions dd%s where m.definition_dimensions_id = dd.id and def.id = dd.definition_id and def.tenant_id = :tenantId and m.time_stamp >= :startTime%s order by dd.id, m.time_stamp, m.id";
    private final DBI db;

    @Inject
    public MeasurementVerticaRepoImpl(@Named(value="vertica") DBI db) {
        this.db = db;
    }

    @Override
    public List<Measurements> find(String tenantId, String name, Map<String, String> dimensions, DateTime startTime, @Nullable DateTime endTime, @Nullable String offset, int limit, Boolean mergeMetricsFlag) {
        try (Handle h = this.db.open();){
            StringBuilder sbWhere = new StringBuilder();
            if (name != null) {
                sbWhere.append(" and def.name = :name");
            }
            if (endTime != null) {
                sbWhere.append(" and m.time_stamp <= :endTime");
            }
            String sql = String.format(FIND_BY_METRIC_DEF_SQL, MetricQueries.buildJoinClauseFor(dimensions), sbWhere);
            Query query = (Query)((Query)h.createQuery(sql).bind("tenantId", tenantId)).bind("startTime", new Timestamp(startTime.getMillis()));
            if (name != null) {
                query.bind("name", name);
            }
            if (endTime != null) {
                query.bind("endTime", new Timestamp(endTime.getMillis()));
            }
            DimensionQueries.bindDimensionsToQuery(query, dimensions);
            List rows = query.list();
            LinkedHashMap<ByteBuffer, Measurements> results = new LinkedHashMap<ByteBuffer, Measurements>();
            for (Map row : rows) {
                String metricName = (String)row.get("name");
                byte[] defIdBytes = (byte[])row.get("definition_dimensions_id");
                byte[] dimSetIdBytes = (byte[])row.get("dimension_set_id");
                ByteBuffer defId = ByteBuffer.wrap(defIdBytes);
                long measurementId = (Long)row.get("id");
                String timestamp = DATETIME_FORMATTER.print(((Timestamp)row.get("time_stamp")).getTime());
                double value = (Double)row.get("value");
                Measurements measurements = (Measurements)((Object)results.get(defId));
                if (measurements == null) {
                    measurements = new Measurements(metricName, MetricQueries.dimensionsFor(h, dimSetIdBytes), new ArrayList<Object[]>());
                    results.put(defId, measurements);
                }
                measurements.addMeasurement(new Object[]{measurementId, timestamp, value, new HashMap()});
            }
            ArrayList<Measurements> arrayList = new ArrayList<Measurements>(results.values());
            return arrayList;
        }
    }
}

