/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.mysql;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.domain.exception.EntityNotFoundException;
import monasca.api.domain.model.alarm.Alarm;
import monasca.api.domain.model.alarm.AlarmRepo;
import monasca.api.infrastructure.persistence.DimensionQueries;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.metric.MetricDefinition;
import monasca.common.persistence.BeanMapper;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmMySqlRepoImpl
implements AlarmRepo {
    private static final Logger logger = LoggerFactory.getLogger(AlarmMySqlRepoImpl.class);
    private final DBI db;
    private final PersistUtils persistUtils;
    private static final String ALARM_SQL = "select ad.id as alarm_definition_id, ad.severity, ad.name as alarm_definition_name, a.id, a.state, a.updated_at as state_updated_timestamp, a.created_at as created_timestamp,md.name as metric_name, mdg.dimensions as metric_dimensions from alarm as a inner join alarm_definition ad on ad.id = a.alarm_definition_id inner join alarm_metric as am on am.alarm_id = a.id inner join metric_definition_dimensions as mdd on mdd.id = am.metric_definition_dimensions_id inner join metric_definition as md on md.id = mdd.metric_definition_id left join (select dimension_set_id, name, value, group_concat(name, '=', value) as dimensions from metric_dimension group by dimension_set_id) as mdg on mdg.dimension_set_id = mdd.metric_dimension_set_id where ad.tenant_id = :tenantId and ad.deleted_at is null %s order by a.id %s";

    @Inject
    public AlarmMySqlRepoImpl(@Named(value="mysql") DBI db, PersistUtils persistUtils) {
        this.db = db;
        this.persistUtils = persistUtils;
    }

    private void buildJoinClauseFor(Map<String, String> dimensions, StringBuilder sbJoin) {
        if (dimensions == null) {
            return;
        }
        for (int i = 0; i < dimensions.size(); ++i) {
            String indexStr = String.valueOf(i);
            sbJoin.append(" inner join metric_dimension md").append(indexStr).append(" on md").append(indexStr).append(".name = :dname").append(indexStr).append(" and md").append(indexStr).append(".value = :dvalue").append(indexStr).append(" and mdd.metric_dimension_set_id = md").append(indexStr).append(".dimension_set_id");
        }
    }

    @Override
    public void deleteById(String tenantId, String id) {
        String sql = "delete a from alarm a where a.id = ?";
        try (Handle h = this.db.open();){
            this.findAlarm(tenantId, id, h);
            h.execute("delete a from alarm a where a.id = ?", new Object[]{id});
        }
    }

    @Override
    public List<Alarm> find(String tenantId, String alarmDefId, String metricName, Map<String, String> metricDimensions, AlarmState state, DateTime stateUpdatedStart, String offset, int limit, boolean enforceLimit) {
        try (Handle h = this.db.open();){
            List<Alarm> alarms;
            StringBuilder sbWhere = new StringBuilder();
            if (alarmDefId != null) {
                sbWhere.append("and ad.id = :alarmDefId ");
            }
            if (metricName != null) {
                sbWhere.append(" and a.id in (select distinct a.id from alarm as a inner join alarm_metric as am on am.alarm_id = a.id inner join metric_definition_dimensions as mdd   on mdd.id = am.metric_definition_dimensions_id inner join (select distinct id from metric_definition             where name = :metricName) as md on md.id = mdd.metric_definition_id ");
                this.buildJoinClauseFor(metricDimensions, sbWhere);
                sbWhere.append(")");
            }
            if (state != null) {
                sbWhere.append(" and a.state = :state");
            }
            if (stateUpdatedStart != null) {
                sbWhere.append(" and a.updated_at >= :stateUpdatedStart");
            }
            if (offset != null) {
                sbWhere.append(" and a.id > :offset");
            }
            String limitPart = "";
            if (enforceLimit && limit > 0) {
                limitPart = " limit :limit";
            }
            String sql = String.format(ALARM_SQL, sbWhere, limitPart);
            Query q = (Query)h.createQuery(sql).bind("tenantId", tenantId);
            if (alarmDefId != null) {
                q.bind("alarmDefId", alarmDefId);
            }
            if (metricName != null) {
                q.bind("metricName", metricName);
            }
            if (state != null) {
                q.bind("state", state.name());
            }
            if (stateUpdatedStart != null) {
                q.bind("stateUpdatedStart", stateUpdatedStart.toString().replace('Z', ' '));
            }
            if (offset != null) {
                q.bind("offset", offset);
            }
            if (enforceLimit && limit > 0) {
                q.bind("limit", limit + 1);
            }
            DimensionQueries.bindDimensionsToQuery(q, metricDimensions);
            long start = System.currentTimeMillis();
            List rows = q.list();
            logger.debug("Query took {} milliseconds", (Object)(System.currentTimeMillis() - start));
            List<Alarm> list = alarms = this.createAlarms(tenantId, rows);
            return list;
        }
    }

    @Override
    public Alarm findById(String tenantId, String alarmId) {
        try (Handle h = this.db.open();){
            Alarm alarm = this.findAlarm(tenantId, alarmId, h);
            return alarm;
        }
    }

    private Alarm findAlarm(String tenantId, String alarmId, Handle h) {
        String sql = String.format(ALARM_SQL, " and a.id = :id", "");
        List rows = ((Query)((Query)h.createQuery(sql).bind("id", alarmId)).bind("tenantId", tenantId)).list();
        if (rows.isEmpty()) {
            throw new EntityNotFoundException("No alarm exists for %s", alarmId);
        }
        return this.createAlarms(tenantId, rows).get(0);
    }

    private List<Alarm> createAlarms(String tenantId, List<Map<String, Object>> rows) {
        Alarm alarm = null;
        String previousAlarmId = null;
        LinkedList<Alarm> alarms = new LinkedList<Alarm>();
        ArrayList<MetricDefinition> alarmedMetrics = null;
        for (Map<String, Object> row : rows) {
            String dimensions;
            String alarmId = (String)row.get("id");
            if (!alarmId.equals(previousAlarmId)) {
                alarmedMetrics = new ArrayList<MetricDefinition>();
                alarm = new Alarm(alarmId, this.getString(row, "alarm_definition_id"), this.getString(row, "alarm_definition_name"), this.getString(row, "severity"), alarmedMetrics, AlarmState.valueOf((String)this.getString(row, "state")), new DateTime(((Timestamp)row.get("state_updated_timestamp")).getTime(), DateTimeZone.forID((String)"UTC")), new DateTime(((Timestamp)row.get("created_timestamp")).getTime(), DateTimeZone.forID((String)"UTC")));
                alarms.add(alarm);
            }
            previousAlarmId = alarmId;
            HashMap<String, Object> dimensionMap = new HashMap<String, Object>();
            if (row.containsKey("metric_dimensions") && (dimensions = this.getString(row, "metric_dimensions")) != null && !dimensions.isEmpty()) {
                for (String dimension : dimensions.split(",")) {
                    Object[] parsed_dimension = dimension.split("=");
                    if (parsed_dimension.length == 2) {
                        dimensionMap.put(parsed_dimension[0], parsed_dimension[1]);
                        continue;
                    }
                    logger.error("Failed to parse dimension. Dimension is malformed: {}", parsed_dimension);
                }
            }
            alarmedMetrics.add(new MetricDefinition(this.getString(row, "metric_name"), dimensionMap));
        }
        return alarms;
    }

    private String getString(Map<String, Object> row, String fieldName) {
        return (String)row.get(fieldName);
    }

    @Override
    public Alarm update(String tenantId, String id, AlarmState state) {
        try (Handle h = this.db.open();){
            h.begin();
            Alarm originalAlarm = this.findAlarm(tenantId, id, h);
            if (!originalAlarm.getState().equals((Object)state)) {
                h.insert("update alarm set state = ?, updated_at = NOW() where id = ?", new Object[]{state.name(), id});
            }
            h.commit();
            Alarm alarm = originalAlarm;
            return alarm;
        }
    }

    @Override
    public Map<String, AlarmSubExpression> findAlarmSubExpressions(String alarmId) {
        try (Handle h = this.db.open();){
            List result = ((Query)h.createQuery("select * from sub_alarm where alarm_id = :alarmId").bind("alarmId", alarmId)).map((ResultSetMapper)new BeanMapper(SubAlarm.class)).list();
            HashMap<String, AlarmSubExpression> subAlarms = new HashMap<String, AlarmSubExpression>(result.size());
            for (SubAlarm row : result) {
                subAlarms.put(row.id, AlarmSubExpression.of((String)row.expression));
            }
            HashMap<String, AlarmSubExpression> hashMap = subAlarms;
            return hashMap;
        }
    }

    @Override
    public Map<String, Map<String, AlarmSubExpression>> findAlarmSubExpressionsForAlarmDefinition(String alarmDefinitionId) {
        try (Handle h = this.db.open();){
            List rows = ((Query)h.createQuery("select sa.* from sub_alarm as sa, alarm as a where sa.alarm_id=a.id and a.alarm_definition_id = :alarmDefinitionId").bind("alarmDefinitionId", alarmDefinitionId)).list();
            HashMap<String, Map<String, AlarmSubExpression>> subAlarms = new HashMap<String, Map<String, AlarmSubExpression>>();
            for (Map row : rows) {
                String alarmId = (String)row.get("alarm_id");
                HashMap<String, AlarmSubExpression> alarmMap = (HashMap<String, AlarmSubExpression>)subAlarms.get(alarmId);
                if (alarmMap == null) {
                    alarmMap = new HashMap<String, AlarmSubExpression>();
                    subAlarms.put(alarmId, alarmMap);
                }
                String id = (String)row.get("id");
                String expression = (String)row.get("expression");
                alarmMap.put(id, AlarmSubExpression.of((String)expression));
            }
            HashMap<String, Map<String, AlarmSubExpression>> hashMap = subAlarms;
            return hashMap;
        }
    }

    public static class SubAlarm {
        private String id;
        private String expression;

        public SubAlarm() {
        }

        public SubAlarm(String id, String expression) {
            this.id = id;
            this.expression = expression;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }
    }
}

