/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.influxdb;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.URLEncoder;
import monasca.api.ApiConfig;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxV9RepoReader {
    private static final Logger logger = LoggerFactory.getLogger(InfluxV9RepoReader.class);
    private final String influxName;
    private final String influxUrl;
    private final String influxCreds;
    private final String influxUser;
    private final String influxPass;
    private final String baseAuthHeader;
    private final boolean gzip;
    private final CloseableHttpClient httpClient;

    @Inject
    public InfluxV9RepoReader(ApiConfig config) {
        this.influxName = config.influxDB.getName();
        logger.debug("Influxdb database name: {}", (Object)this.influxName);
        this.influxUrl = config.influxDB.getUrl() + "/query";
        logger.debug("Influxdb URL: {}", (Object)this.influxUrl);
        this.influxUser = config.influxDB.getUser();
        this.influxPass = config.influxDB.getPassword();
        this.influxCreds = this.influxUser + ":" + this.influxPass;
        this.gzip = config.influxDB.getGzip();
        logger.debug("Influxdb gzip responses: {}", (Object)this.gzip);
        logger.debug("Setting up basic Base64 authentication");
        this.baseAuthHeader = "Basic " + new String(Base64.encodeBase64((byte[])this.influxCreds.getBytes()));
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(config.influxDB.getMaxHttpConnections());
        if (this.gzip) {
            logger.debug("Setting up gzip responses from Influxdb");
            this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).addInterceptorFirst(new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    if (!request.containsHeader("Accept-Encoding")) {
                        request.addHeader("Accept-Encoding", "gzip");
                    }
                }
            }).addInterceptorFirst(new HttpResponseInterceptor(){

                public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                    Header ceheader;
                    HttpEntity entity = response.getEntity();
                    if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                        HeaderElement[] codecs = ceheader.getElements();
                        for (int i = 0; i < codecs.length; ++i) {
                            if (!codecs[i].getName().equalsIgnoreCase("gzip")) continue;
                            response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                            return;
                        }
                    }
                }
            }).build();
        } else {
            logger.debug("Setting up non-gzip responses from Influxdb");
            this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String read(String query) throws Exception {
        HttpGet request = new HttpGet(this.influxUrl + "?q=" + URLEncoder.encode(query, "UTF-8") + "&db=" + URLEncoder.encode(this.influxName, "UTF-8"));
        request.addHeader("content-type", "application/json");
        request.addHeader("Authorization", this.baseAuthHeader);
        try {
            logger.debug("Sending query {} to influx database {} at {}", new Object[]{query, this.influxName, this.influxUrl});
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            int rc = response.getStatusLine().getStatusCode();
            logger.debug("Received {} status code from influx database {} at {}", new Object[]{rc, this.influxName, this.influxUrl});
            if (rc != 200) {
                HttpEntity entity = response.getEntity();
                String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                logger.error("Failed to query influx database {} at {}: {}", new Object[]{this.influxName, this.influxUrl, String.valueOf(rc)});
                logger.error("Http response: {}", (Object)responseString);
                throw new Exception(rc + ":" + responseString);
            }
            logger.debug("Successfully queried influx database {} at {}", (Object)this.influxName, (Object)this.influxUrl);
            HttpEntity entity = response.getEntity();
            String string = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : null;
            return string;
        }
        finally {
            request.releaseConnection();
        }
    }
}

