/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import javax.inject.Singleton;
import monasca.api.ApiConfig;
import monasca.api.domain.model.alarm.AlarmRepo;
import monasca.api.domain.model.alarmdefinition.AlarmDefinitionRepo;
import monasca.api.domain.model.alarmstatehistory.AlarmStateHistoryRepo;
import monasca.api.domain.model.measurement.MeasurementRepo;
import monasca.api.domain.model.metric.MetricDefinitionRepo;
import monasca.api.domain.model.notificationmethod.NotificationMethodRepo;
import monasca.api.domain.model.statistic.StatisticRepo;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.infrastructure.persistence.influxdb.InfluxV9AlarmStateHistoryRepo;
import monasca.api.infrastructure.persistence.influxdb.InfluxV9MeasurementRepo;
import monasca.api.infrastructure.persistence.influxdb.InfluxV9MetricDefinitionRepo;
import monasca.api.infrastructure.persistence.influxdb.InfluxV9RepoReader;
import monasca.api.infrastructure.persistence.influxdb.InfluxV9StatisticRepo;
import monasca.api.infrastructure.persistence.influxdb.InfluxV9Utils;
import monasca.api.infrastructure.persistence.mysql.AlarmDefinitionMySqlRepoImpl;
import monasca.api.infrastructure.persistence.mysql.AlarmMySqlRepoImpl;
import monasca.api.infrastructure.persistence.mysql.NotificationMethodMySqlRepoImpl;
import monasca.api.infrastructure.persistence.vertica.AlarmStateHistoryVerticaRepoImpl;
import monasca.api.infrastructure.persistence.vertica.MeasurementVerticaRepoImpl;
import monasca.api.infrastructure.persistence.vertica.MetricDefinitionVerticaRepoImpl;
import monasca.api.infrastructure.persistence.vertica.StatisticVerticaRepoImpl;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;

public class InfrastructureModule
extends AbstractModule {
    private ApiConfig config;
    private static final String VERTICA = "vertica";
    private static final String INFLUXDB = "influxdb";
    private static final String INFLUXDB_V9 = "v9";

    public InfrastructureModule(ApiConfig config) {
        this.config = config;
    }

    protected void configure() {
        this.bind(AlarmRepo.class).to(AlarmMySqlRepoImpl.class).in(Singleton.class);
        this.bind(AlarmDefinitionRepo.class).to(AlarmDefinitionMySqlRepoImpl.class).in(Singleton.class);
        if (this.config.databaseConfiguration.getDatabaseType().trim().equalsIgnoreCase(VERTICA)) {
            this.bind(AlarmStateHistoryRepo.class).to(AlarmStateHistoryVerticaRepoImpl.class).in(Singleton.class);
            this.bind(MetricDefinitionRepo.class).to(MetricDefinitionVerticaRepoImpl.class).in(Singleton.class);
            this.bind(MeasurementRepo.class).to(MeasurementVerticaRepoImpl.class).in(Singleton.class);
            this.bind(StatisticRepo.class).to(StatisticVerticaRepoImpl.class).in(Singleton.class);
        } else if (this.config.databaseConfiguration.getDatabaseType().trim().equalsIgnoreCase(INFLUXDB)) {
            if (this.config.influxDB.getVersion() != null && !this.config.influxDB.getVersion().equalsIgnoreCase(INFLUXDB_V9)) {
                System.err.println("Found unsupported Influxdb version: " + this.config.influxDB.getVersion());
                System.err.println("Supported Influxdb versions are 'v9'");
                System.err.println("Check your config file");
                System.exit(1);
            }
            this.bind(PersistUtils.class).in(Singleton.class);
            this.bind(InfluxV9Utils.class).in(Singleton.class);
            this.bind(InfluxV9RepoReader.class).in(Singleton.class);
            this.bind(AlarmStateHistoryRepo.class).to(InfluxV9AlarmStateHistoryRepo.class).in(Singleton.class);
            this.bind(MetricDefinitionRepo.class).to(InfluxV9MetricDefinitionRepo.class).in(Singleton.class);
            this.bind(MeasurementRepo.class).to(InfluxV9MeasurementRepo.class).in(Singleton.class);
            this.bind(StatisticRepo.class).to(InfluxV9StatisticRepo.class).in(Singleton.class);
        } else {
            throw new ProvisionException("Failed to detect supported database. Supported databases are 'vertica' and 'influxdb'. Check your config file.");
        }
        this.bind(NotificationMethodRepo.class).to(NotificationMethodMySqlRepoImpl.class).in(Singleton.class);
    }

    @Provides
    InfluxDB provideInfluxDB() {
        InfluxDB influxDB = InfluxDBFactory.connect((String)this.config.influxDB.getUrl(), (String)this.config.influxDB.getUser(), (String)this.config.influxDB.getPassword());
        return influxDB;
    }
}

