/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.domain.model.alarmstatehistory;

import java.util.List;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmTransitionSubAlarm;
import monasca.common.model.domain.common.AbstractEntity;
import monasca.common.model.metric.MetricDefinition;
import org.joda.time.DateTime;

public class AlarmStateHistory
extends AbstractEntity {
    private String alarmId;
    private List<MetricDefinition> metrics;
    private AlarmState oldState;
    private AlarmState newState;
    private String reason;
    private String reasonData;
    private DateTime timestamp;
    private List<AlarmTransitionSubAlarm> subAlarms;

    public AlarmStateHistory() {
    }

    public AlarmStateHistory(String alarmId, List<MetricDefinition> metrics, AlarmState oldState, AlarmState newState, List<AlarmTransitionSubAlarm> subAlarms, String reason, String reasonData, DateTime timestamp) {
        this.id = new Long(timestamp.getMillis()).toString();
        this.alarmId = alarmId;
        this.setMetrics(metrics);
        this.oldState = oldState;
        this.newState = newState;
        this.subAlarms = subAlarms;
        this.reason = reason;
        this.reasonData = reasonData;
        this.timestamp = timestamp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmStateHistory)) {
            return false;
        }
        AlarmStateHistory other = (AlarmStateHistory)((Object)obj);
        if (this.alarmId == null ? other.alarmId != null : !this.alarmId.equals(other.alarmId)) {
            return false;
        }
        if (this.metrics == null ? other.metrics != null : !this.metrics.equals(other.metrics)) {
            return false;
        }
        if (this.newState != other.newState) {
            return false;
        }
        if (this.oldState != other.oldState) {
            return false;
        }
        if (this.subAlarms == null ? other.subAlarms != null : !this.subAlarms.equals(other.subAlarms)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
            return false;
        }
        if (this.reasonData == null ? other.reasonData != null : !this.reasonData.equals(other.reasonData)) {
            return false;
        }
        return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals((Object)other.timestamp));
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAlarmId() {
        return this.alarmId;
    }

    public List<MetricDefinition> getMetrics() {
        return this.metrics;
    }

    public AlarmState getNewState() {
        return this.newState;
    }

    public AlarmState getOldState() {
        return this.oldState;
    }

    public String getReason() {
        return this.reason;
    }

    public String getReasonData() {
        return this.reasonData;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alarmId == null ? 0 : this.alarmId.hashCode());
        result = 31 * result + (this.metrics == null ? 0 : this.metrics.hashCode());
        result = 31 * result + (this.newState == null ? 0 : this.newState.hashCode());
        result = 31 * result + (this.oldState == null ? 0 : this.oldState.hashCode());
        result = 31 * result + (this.subAlarms == null ? 0 : this.subAlarms.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.reasonData == null ? 0 : this.reasonData.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public void setAlarmId(String alarmId) {
        this.alarmId = alarmId;
    }

    public void setMetrics(List<MetricDefinition> metrics) {
        this.metrics = metrics;
    }

    public void setNewState(AlarmState newState) {
        this.newState = newState;
    }

    public void setOldState(AlarmState oldState) {
        this.oldState = oldState;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setReasonData(String reasonData) {
        this.reasonData = reasonData;
    }

    public List<AlarmTransitionSubAlarm> getSubAlarms() {
        return this.subAlarms;
    }

    public void setSubAlarms(List<AlarmTransitionSubAlarm> subAlarms) {
        this.subAlarms = subAlarms;
    }

    public void setTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
        this.id = new Long(timestamp.getMillis()).toString();
    }

    public String toString() {
        return "AlarmStateHistory [alarmId=" + this.alarmId + ", metrics=" + this.metrics + ", oldState=" + this.oldState + ", newState=" + this.newState + ", subAlarms=" + this.subAlarms + ", reason=" + this.reason + ", reasonData=" + this.reasonData + ", timestamp=" + this.timestamp + "]";
    }
}

