/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Base64Coder;
import net.bull.javamelody.LOG;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

class HttpAuth {
    private static final long AUTH_FAILURES_MAX = 10L;
    private static final long LOCK_DURATION = 3600000L;
    private final Pattern allowedAddrPattern;
    private final List<String> authorizedUsers;
    private final AtomicInteger authFailuresCount = new AtomicInteger();
    private Date firstFailureDate;

    HttpAuth() {
        this.allowedAddrPattern = HttpAuth.getAllowedAddrPattern();
        this.authorizedUsers = HttpAuth.getAuthorizedUsers();
    }

    private static Pattern getAllowedAddrPattern() {
        if (Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN) != null) {
            return Pattern.compile(Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN));
        }
        return null;
    }

    private static List<String> getAuthorizedUsers() {
        String authUsersInParam = Parameters.getParameter(Parameter.AUTHORIZED_USERS);
        if (authUsersInParam != null && !authUsersInParam.trim().isEmpty()) {
            ArrayList<String> authorizedUsers = new ArrayList<String>();
            for (String authUser : authUsersInParam.split("[\n,]")) {
                String authUserTrim = authUser.trim();
                if (authUserTrim.isEmpty()) continue;
                authorizedUsers.add(authUserTrim);
                LOG.debug("Authorized user: " + authUserTrim.split(":", 2)[0]);
            }
            return authorizedUsers;
        }
        return null;
    }

    boolean isAllowed(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (!this.isRequestAllowed(httpRequest)) {
            LOG.debug("Forbidden access to monitoring from " + httpRequest.getRemoteAddr());
            httpResponse.sendError(403, "Forbidden access");
            return false;
        }
        if (!this.isUserAuthorized(httpRequest)) {
            httpResponse.setHeader("WWW-Authenticate", "BASIC realm=\"JavaMelody\"");
            if (this.isLocked()) {
                httpResponse.sendError(401, "Unauthorized (locked)");
            } else {
                httpResponse.sendError(401, "Unauthorized");
            }
            return false;
        }
        return true;
    }

    private boolean isRequestAllowed(HttpServletRequest httpRequest) {
        return this.allowedAddrPattern == null || this.allowedAddrPattern.matcher(httpRequest.getRemoteAddr()).matches();
    }

    private boolean isUserAuthorized(HttpServletRequest httpRequest) {
        if (this.authorizedUsers == null) {
            return true;
        }
        String auth = httpRequest.getHeader("Authorization");
        if (auth == null) {
            return false;
        }
        if (!auth.toUpperCase(Locale.ENGLISH).startsWith("BASIC ")) {
            return false;
        }
        String userpassEncoded = auth.substring("BASIC ".length());
        String userpassDecoded = Base64Coder.decodeString(userpassEncoded);
        boolean authOk = this.authorizedUsers.contains(userpassDecoded);
        return this.checkLockAgainstBruteForceAttack(authOk);
    }

    private boolean checkLockAgainstBruteForceAttack(boolean authOk) {
        if (this.firstFailureDate == null) {
            if (!authOk) {
                this.firstFailureDate = new Date();
                this.authFailuresCount.set(1);
            }
        } else {
            if (this.isLocked()) {
                if (System.currentTimeMillis() - this.firstFailureDate.getTime() < 3600000L) {
                    return false;
                }
                this.firstFailureDate = null;
                this.authFailuresCount.set(0);
                return this.checkLockAgainstBruteForceAttack(authOk);
            }
            if (authOk) {
                this.firstFailureDate = null;
                this.authFailuresCount.set(0);
            } else {
                this.authFailuresCount.incrementAndGet();
            }
        }
        return authOk;
    }

    private boolean isLocked() {
        return (long)this.authFailuresCount.get() > 10L;
    }
}

