/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.its.storyboard;

import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.PluginConfigFactory;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.googlesource.gerrit.plugins.hooks.ItsHookModule;
import com.googlesource.gerrit.plugins.hooks.its.ItsFacade;
import com.googlesource.gerrit.plugins.its.storyboard.StoryboardItsFacade;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoryboardModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(StoryboardModule.class);
    private final String pluginName;
    private final Config gerritConfig;
    private final PluginConfigFactory pluginCfgFactory;

    @Inject
    public StoryboardModule(@PluginName String pluginName, @GerritServerConfig Config config, PluginConfigFactory pluginCfgFactory) {
        this.pluginName = pluginName;
        this.gerritConfig = config;
        this.pluginCfgFactory = pluginCfgFactory;
    }

    protected void configure() {
        if (this.gerritConfig.getString(this.pluginName, null, "url") != null) {
            log.info("Storyboard is configured as ITS");
            this.bind(ItsFacade.class).toInstance((Object)new StoryboardItsFacade(this.pluginName, this.gerritConfig));
            this.install((Module)new ItsHookModule(this.pluginName, this.pluginCfgFactory));
        }
    }
}

