/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.workflow;

import com.google.gerrit.common.EventListener;
import com.google.gerrit.server.events.Event;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.hooks.its.ItsConfig;
import com.googlesource.gerrit.plugins.hooks.util.PropertyExtractor;
import com.googlesource.gerrit.plugins.hooks.workflow.ActionExecutor;
import com.googlesource.gerrit.plugins.hooks.workflow.ActionRequest;
import com.googlesource.gerrit.plugins.hooks.workflow.Property;
import com.googlesource.gerrit.plugins.hooks.workflow.RuleBase;
import java.util.Collection;
import java.util.Set;

public class ActionController
implements EventListener {
    private final PropertyExtractor propertyExtractor;
    private final RuleBase ruleBase;
    private final ActionExecutor actionExecutor;
    private final ItsConfig itsConfig;

    @Inject
    public ActionController(PropertyExtractor propertyExtractor, RuleBase ruleBase, ActionExecutor actionExecutor, ItsConfig itsConfig) {
        this.propertyExtractor = propertyExtractor;
        this.ruleBase = ruleBase;
        this.actionExecutor = actionExecutor;
        this.itsConfig = itsConfig;
    }

    public void onEvent(Event event) {
        if (!this.itsConfig.isEnabled(event)) {
            return;
        }
        Set<Set<Property>> propertiesCollections = this.propertyExtractor.extractFrom(event);
        for (Set<Property> properties : propertiesCollections) {
            Collection<ActionRequest> actions = this.ruleBase.actionRequestsFor(properties);
            if (actions.isEmpty()) continue;
            for (Property property : properties) {
                if (!"issue".equals(property.getKey())) continue;
                String issue = property.getValue();
                this.actionExecutor.execute(issue, actions, properties);
            }
        }
    }
}

