/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.validation;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.events.CommitReceivedEvent;
import com.google.gerrit.server.git.validators.CommitValidationException;
import com.google.gerrit.server.git.validators.CommitValidationListener;
import com.google.gerrit.server.git.validators.CommitValidationMessage;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.hooks.its.ItsConfig;
import com.googlesource.gerrit.plugins.hooks.its.ItsFacade;
import com.googlesource.gerrit.plugins.hooks.util.IssueExtractor;
import com.googlesource.gerrit.plugins.hooks.validation.ItsAssociationPolicy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItsValidateComment
implements CommitValidationListener {
    private static final Logger log = LoggerFactory.getLogger(ItsValidateComment.class);
    @Inject
    private ItsFacade client;
    @Inject
    @GerritServerConfig
    private Config gerritConfig;
    @Inject
    @PluginName
    private String pluginName;
    @Inject
    private ItsConfig itsConfig;
    @Inject
    private IssueExtractor issueExtractor;

    private List<CommitValidationMessage> validCommit(ReceiveCommand cmd, RevCommit commit) throws CommitValidationException {
        ArrayList ret = Lists.newArrayList();
        ItsAssociationPolicy associationPolicy = this.getItsAssociationPolicy();
        switch (associationPolicy) {
            case MANDATORY: 
            case SUGGESTED: {
                String commitMessage = commit.getFullMessage();
                String[] issueIds = this.issueExtractor.getIssueIds(commitMessage);
                String synopsis = null;
                String details = null;
                if (issueIds.length > 0) {
                    ArrayList nonExistingIssueIds = Lists.newArrayList();
                    for (String issueId : issueIds) {
                        boolean exists = false;
                        try {
                            exists = this.client.exists(issueId);
                        }
                        catch (IOException e) {
                            synopsis = "Failed to check whether or not issue " + issueId + " exists";
                            log.warn(synopsis, (Throwable)e);
                            details = e.toString();
                            ret.add(this.commitValidationFailure(synopsis, details));
                        }
                        if (exists) continue;
                        nonExistingIssueIds.add(issueId);
                    }
                    if (nonExistingIssueIds.isEmpty()) break;
                    synopsis = "Non-existing issue ids referenced in commit message";
                    StringBuilder sb = new StringBuilder();
                    sb.append("The issue-ids\n");
                    for (String issueId : nonExistingIssueIds) {
                        sb.append("    * ");
                        sb.append(issueId);
                        sb.append("\n");
                    }
                    sb.append("are referenced in the commit message of\n");
                    sb.append(commit.getId().getName());
                    sb.append(",\n");
                    sb.append("but do not exist in ");
                    sb.append(this.pluginName);
                    sb.append(" Issue-Tracker");
                    details = sb.toString();
                    ret.add(this.commitValidationFailure(synopsis, details));
                    break;
                }
                synopsis = "Missing issue-id in commit message";
                StringBuilder sb = new StringBuilder();
                sb.append("Commit ");
                sb.append(commit.getId().getName());
                sb.append(" not associated to any issue\n");
                sb.append("\n");
                sb.append("Hint: insert one or more issue-id anywhere in the ");
                sb.append("commit message.\n");
                sb.append("      Issue-ids are strings matching ");
                sb.append(this.issueExtractor.getPattern().pattern());
                sb.append("\n");
                sb.append("      and are pointing to existing tickets on ");
                sb.append(this.pluginName);
                sb.append(" Issue-Tracker");
                details = sb.toString();
                ret.add(this.commitValidationFailure(synopsis, details));
                break;
            }
        }
        return ret;
    }

    private ItsAssociationPolicy getItsAssociationPolicy() {
        return (ItsAssociationPolicy)this.gerritConfig.getEnum("commentLink", this.pluginName, "association", (Enum)ItsAssociationPolicy.OPTIONAL);
    }

    private CommitValidationMessage commitValidationFailure(String synopsis, String details) throws CommitValidationException {
        CommitValidationMessage ret = new CommitValidationMessage(synopsis + "\n" + details, false);
        if (this.getItsAssociationPolicy() == ItsAssociationPolicy.MANDATORY) {
            throw new CommitValidationException(synopsis, Collections.singletonList(ret));
        }
        return ret;
    }

    public List<CommitValidationMessage> onCommitReceived(CommitReceivedEvent receiveEvent) throws CommitValidationException {
        if (this.itsConfig.isEnabled(receiveEvent.project.getName(), receiveEvent.refName)) {
            return this.validCommit(receiveEvent.command, receiveEvent.commit);
        }
        return Collections.emptyList();
    }
}

