/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.its.storyboard;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoryboardClient {
    private static final Logger log = LoggerFactory.getLogger(StoryboardClient.class);
    public static final String STORIES_ENDPOINT = "/api/v1/stories";
    public static final String SYS_INFO_ENDPOINT = "/api/v1/systeminfo";
    public static final String TASKS_ENDPOINT = "/api/v1/tasks";
    private final String baseUrl;
    private final String password;

    public StoryboardClient(String baseUrl, String password) {
        this.baseUrl = baseUrl;
        this.password = password;
    }

    public String getData(String url) throws IOException {
        HttpGet httpget = new HttpGet(url);
        try (CloseableHttpClient client = HttpClients.createDefault();
             CloseableHttpResponse response = client.execute(httpget);){
            log.debug("Making request for " + httpget.getRequestLine());
            StatusLine sl = response.getStatusLine();
            int responseCode = sl.getStatusCode();
            if (responseCode == 200) {
                log.debug("Retreiving data from response " + httpget.getRequestLine());
                InputStream inputStream = response.getEntity().getContent();
                InputStreamReader reader = new InputStreamReader(inputStream);
                int contentLength = (int)response.getEntity().getContentLength();
                char[] charArray = new char[contentLength];
                reader.read(charArray);
                String responseJson = new String(charArray);
                log.debug("Data retreived: " + responseJson);
                String string = responseJson;
                return string;
            }
            log.error("Failed request: " + httpget.getRequestLine() + " with response: " + responseCode);
        }
        return null;
    }

    public void postData(String url, String data) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Authorization", "Bearer " + this.password);
        httpPost.addHeader("Content-Type", "application/json; charset=utf-8");
        httpPost.setEntity(new StringEntity(data, "utf-8"));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();
             CloseableHttpResponse response = httpclient.execute(httpPost);){
            log.debug("Executing request " + httpPost.getRequestLine());
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                log.info("Updated " + url + " with " + data);
            } else {
                log.error("Failed to post, response: " + responseCode + " (" + response.getStatusLine().getReasonPhrase() + ")");
            }
        }
    }

    public void putData(String url, String data) throws IOException {
        HttpPut HttpPut2 = new HttpPut(url);
        HttpPut2.addHeader("Authorization", "Bearer " + this.password);
        HttpPut2.addHeader("Content-Type", "application/json; charset=utf-8");
        HttpPut2.setEntity(new StringEntity(data, "utf-8"));
        try (CloseableHttpClient httpclient = HttpClients.createDefault();
             CloseableHttpResponse response = httpclient.execute(HttpPut2);){
            log.debug("Executing request " + HttpPut2.getRequestLine());
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                log.info("Updated " + url + " with " + data);
            } else {
                log.error("Failed to post, response: " + responseCode + " (" + response.getStatusLine().getReasonPhrase() + ")");
            }
        }
    }

    public String getSysInfo() throws IOException {
        return this.getData(this.baseUrl + SYS_INFO_ENDPOINT);
    }

    public String getStory(String id) throws IOException {
        return this.getData(this.baseUrl + STORIES_ENDPOINT + "/" + this.getStoryId(id));
    }

    public int getStoryId(String issueId) throws IOException {
        String taskJson = this.getTask(issueId);
        JsonObject jobj = new Gson().fromJson(taskJson, JsonObject.class);
        return jobj.get("story_id").getAsInt();
    }

    public String getTask(String issueId) throws IOException {
        return this.getData(this.baseUrl + TASKS_ENDPOINT + "/" + issueId);
    }

    public void setStatus(String issueId, String status) throws IOException {
        log.debug("PUT task with data: ({},{})", (Object)issueId, (Object)status);
        String url = this.baseUrl + TASKS_ENDPOINT + "/" + issueId;
        String json = "{\"task_id\":\"" + issueId + "\",\"status\":\"" + status + "\"}";
        this.putData(url, json);
    }

    public String getTaskStatus(String issueId) throws IOException {
        String taskJson = this.getTask(issueId);
        JsonObject jobj = new Gson().fromJson(taskJson, JsonObject.class);
        return jobj.get("status").getAsString();
    }

    public String getTaskNotes(String issueId) throws IOException {
        String taskJson = this.getTask(issueId);
        JsonObject jobj = new Gson().fromJson(taskJson, JsonObject.class);
        return jobj.get("link").getAsString();
    }

    public void addComment(String issueId, String comment) throws IOException {
        int story_id = this.getStoryId(issueId);
        log.debug("Posting comment with data: ({},{})", (Object)story_id, (Object)comment);
        String url = this.baseUrl + STORIES_ENDPOINT + "/" + story_id + "/comments";
        String escapedComment = comment.replace("\n", "\\n");
        String json = "{\"story_id\":\"" + issueId + "\",\"content\":\"" + escapedComment + "\"}";
        this.postData(url, json);
    }
}

