/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.workflow;

import com.google.gerrit.server.config.SitePath;
import com.google.gerrit.server.data.ApprovalAttribute;
import com.google.gerrit.server.data.ChangeAttribute;
import com.google.gerrit.server.events.ChangeAbandonedEvent;
import com.google.gerrit.server.events.ChangeMergedEvent;
import com.google.gerrit.server.events.ChangeRestoredEvent;
import com.google.gerrit.server.events.CommentAddedEvent;
import com.google.gerrit.server.events.PatchSetCreatedEvent;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.hooks.its.InvalidTransitionException;
import com.googlesource.gerrit.plugins.hooks.its.ItsFacade;
import com.googlesource.gerrit.plugins.hooks.util.IssueExtractor;
import com.googlesource.gerrit.plugins.hooks.workflow.GerritHookFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritHookFilterChangeState
extends GerritHookFilter {
    private static final Logger log = LoggerFactory.getLogger(GerritHookFilterChangeState.class);
    @Inject
    private ItsFacade its;
    @Inject
    @SitePath
    private File sitePath;
    @Inject
    private IssueExtractor issueExtractor;

    @Override
    public void doFilter(PatchSetCreatedEvent hook) throws IOException {
        this.performAction(hook.change, new Condition("change", "created"));
    }

    @Override
    public void doFilter(CommentAddedEvent hook) throws IOException {
        try {
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            conditions.add(new Condition("change", "commented"));
            if (hook.approvals != null) {
                for (ApprovalAttribute approval : hook.approvals) {
                    this.addApprovalCategoryCondition(conditions, approval.type, approval.value);
                }
            }
            this.performAction(hook.change, conditions.toArray(new Condition[conditions.size()]));
        }
        catch (InvalidTransitionException ex) {
            log.warn(ex.getMessage());
        }
    }

    @Override
    public void doFilter(ChangeMergedEvent hook) throws IOException {
        this.performAction(hook.change, new Condition("change", "merged"));
    }

    @Override
    public void doFilter(ChangeAbandonedEvent hook) throws IOException {
        this.performAction(hook.change, new Condition("change", "abandoned"));
    }

    @Override
    public void doFilter(ChangeRestoredEvent hook) throws IOException {
        this.performAction(hook.change, new Condition("change", "restored"));
    }

    private void addApprovalCategoryCondition(List<Condition> conditions, String name, String value) {
        if ((value = this.toConditionValue(value)) == null) {
            return;
        }
        conditions.add(new Condition(name, value));
    }

    private String toConditionValue(String text) {
        if (text == null) {
            return null;
        }
        try {
            int val = Integer.parseInt(text);
            if (val > 0) {
                return "+" + val;
            }
            return text;
        }
        catch (Exception any) {
            return null;
        }
    }

    private void performAction(ChangeAttribute change, Condition ... conditionArgs) throws IOException {
        String[] issues;
        List<Condition> conditions = Arrays.asList(conditionArgs);
        log.debug("Checking suitable transition for: " + conditions);
        Transition transition = null;
        List<Transition> transitions = this.loadTransitions();
        for (Transition tx : transitions) {
            log.debug("Checking transition: " + tx);
            if (!tx.matches(conditions)) continue;
            log.debug("Transition FOUND > " + tx.getAction());
            transition = tx;
            break;
        }
        if (transition == null) {
            log.debug("Nothing to perform, transition not found for conditions " + conditions);
            return;
        }
        String gitComment = change.subject;
        for (String issue : issues = this.issueExtractor.getIssueIds(gitComment)) {
            this.its.performAction(issue, transition.getAction());
        }
    }

    private List<Transition> loadTransitions() {
        File configFile = new File(this.sitePath, "etc/issue-state-transition.config");
        FileBasedConfig cfg = new FileBasedConfig(configFile, FS.DETECTED);
        try {
            cfg.load();
        }
        catch (IOException e) {
            log.error("Cannot load transitions configuration file " + cfg, (Throwable)e);
            return Collections.emptyList();
        }
        catch (ConfigInvalidException e) {
            log.error("Invalid transitions configuration file" + cfg, (Throwable)e);
            return Collections.emptyList();
        }
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        Set sections = cfg.getSubsections("action");
        for (String section : sections) {
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            Set keys = cfg.getNames("action", section);
            for (String key : keys) {
                String val = cfg.getString("action", section, key);
                conditions.add(new Condition(key.trim(), val.trim().split(",")));
            }
            transitions.add(new Transition(this.toAction(section), conditions));
        }
        return transitions;
    }

    private String toAction(String name) {
        name = name.trim();
        try {
            int i = name.lastIndexOf(32);
            Integer.parseInt(name.substring(i + 1));
            name = name.substring(0, i);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public class Transition {
        private String action;
        private List<Condition> conditions;

        public Transition(String action, List<Condition> conditions) {
            this.action = action;
            this.conditions = conditions;
        }

        public String getAction() {
            return this.action;
        }

        public List<Condition> getCondition() {
            return this.conditions;
        }

        public boolean matches(List<Condition> eventConditions) {
            for (Condition condition : this.conditions) {
                if (eventConditions.contains(condition)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "action=\"" + this.action + "\", conditions=" + this.conditions;
        }
    }

    public class Condition {
        private String key;
        private String[] val;

        public Condition(String key, String[] values) {
            this.key = key.toLowerCase();
            this.val = values;
        }

        public Condition(String key, String value) {
            this(key, new String[]{value});
        }

        public String getKey() {
            return this.key;
        }

        public String[] getVal() {
            return this.val;
        }

        public boolean equals(Object o) {
            try {
                Condition other = (Condition)o;
                if (!this.key.equals(other.key)) {
                    return false;
                }
                boolean valMatch = false;
                List<String> otherVals = Arrays.asList(other.val);
                for (String value : this.val) {
                    if (!otherVals.contains(value)) continue;
                    valMatch = true;
                }
                return valMatch;
            }
            catch (Exception any) {
                return false;
            }
        }

        public String toString() {
            return this.key + "=" + Arrays.asList(this.val);
        }
    }
}

