/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.its.base.workflow;

import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.its.base.its.ItsFacade;
import com.googlesource.gerrit.plugins.its.base.workflow.ActionRequest;
import com.googlesource.gerrit.plugins.its.base.workflow.Property;
import com.googlesource.gerrit.plugins.its.base.workflow.action.Action;
import com.googlesource.gerrit.plugins.its.base.workflow.action.AddComment;
import com.googlesource.gerrit.plugins.its.base.workflow.action.AddStandardComment;
import com.googlesource.gerrit.plugins.its.base.workflow.action.AddVelocityComment;
import com.googlesource.gerrit.plugins.its.base.workflow.action.LogEvent;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionExecutor {
    private static final Logger log = LoggerFactory.getLogger(ActionExecutor.class);
    private final ItsFacade its;
    private final AddComment.Factory addCommentFactory;
    private final AddStandardComment.Factory addStandardCommentFactory;
    private final AddVelocityComment.Factory addVelocityCommentFactory;
    private final LogEvent.Factory logEventFactory;

    @Inject
    public ActionExecutor(ItsFacade its, AddComment.Factory addCommentFactory, AddStandardComment.Factory addStandardCommentFactory, AddVelocityComment.Factory addVelocityCommentFactory, LogEvent.Factory logEventFactory) {
        this.its = its;
        this.addCommentFactory = addCommentFactory;
        this.addStandardCommentFactory = addStandardCommentFactory;
        this.addVelocityCommentFactory = addVelocityCommentFactory;
        this.logEventFactory = logEventFactory;
    }

    public void execute(String issue, ActionRequest actionRequest, Set<Property> properties) {
        try {
            String name = actionRequest.getName();
            Action action = null;
            if ("add-comment".equals(name)) {
                action = this.addCommentFactory.create();
            } else if ("add-standard-comment".equals(name)) {
                action = this.addStandardCommentFactory.create();
            } else if ("add-velocity-comment".equals(name)) {
                action = this.addVelocityCommentFactory.create();
            } else if ("log-event".equals(name)) {
                action = this.logEventFactory.create();
            }
            if (action == null) {
                this.its.performAction(issue, actionRequest.getUnparsed());
            } else {
                action.execute(issue, actionRequest, properties);
            }
        }
        catch (IOException e) {
            log.error("Error while executing action " + actionRequest, (Throwable)e);
        }
    }

    public void execute(String issue, Iterable<ActionRequest> actions, Set<Property> properties) {
        for (ActionRequest actionRequest : actions) {
            this.execute(issue, actionRequest, properties);
        }
    }
}

