/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.its.base.util;

import com.google.common.collect.Sets;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.data.AccountAttribute;
import com.google.gerrit.server.data.ApprovalAttribute;
import com.google.gerrit.server.data.ChangeAttribute;
import com.google.gerrit.server.data.PatchSetAttribute;
import com.google.gerrit.server.data.RefUpdateAttribute;
import com.google.gerrit.server.events.ChangeAbandonedEvent;
import com.google.gerrit.server.events.ChangeMergedEvent;
import com.google.gerrit.server.events.ChangeRestoredEvent;
import com.google.gerrit.server.events.CommentAddedEvent;
import com.google.gerrit.server.events.DraftPublishedEvent;
import com.google.gerrit.server.events.Event;
import com.google.gerrit.server.events.PatchSetCreatedEvent;
import com.google.gerrit.server.events.PatchSetEvent;
import com.google.gerrit.server.events.RefUpdatedEvent;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.its.base.util.IssueExtractor;
import com.googlesource.gerrit.plugins.its.base.util.PropertyAttributeExtractor;
import com.googlesource.gerrit.plugins.its.base.workflow.Property;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PropertyExtractor {
    private IssueExtractor issueExtractor;
    private Property.Factory propertyFactory;
    private PropertyAttributeExtractor propertyAttributeExtractor;
    private final String pluginName;

    @Inject
    PropertyExtractor(IssueExtractor issueExtractor, Property.Factory propertyFactory, PropertyAttributeExtractor propertyAttributeExtractor, @PluginName String pluginName) {
        this.issueExtractor = issueExtractor;
        this.propertyFactory = propertyFactory;
        this.propertyAttributeExtractor = propertyAttributeExtractor;
        this.pluginName = pluginName;
    }

    private PatchSet.Id newPatchSetId(String changeId, String patchId) {
        try {
            return new PatchSet.Id(new Change.Id(Integer.parseInt(changeId)), Integer.parseInt(patchId));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Map<String, Set<String>> extractFrom(PatchSetEvent event, Set<Property> common) {
        common.add(this.propertyFactory.create("event-type", event.type));
        ChangeAttribute change = (ChangeAttribute)event.change.get();
        PatchSetAttribute patchSet = (PatchSetAttribute)event.patchSet.get();
        common.addAll(this.propertyAttributeExtractor.extractFrom(change));
        common.addAll(this.propertyAttributeExtractor.extractFrom(patchSet));
        PatchSet.Id patchSetId = this.newPatchSetId(change.number, patchSet.number);
        return this.issueExtractor.getIssueIds(change.project, patchSet.revision, patchSetId);
    }

    private Map<String, Set<String>> extractFrom(ChangeAbandonedEvent event, Set<Property> common) {
        common.addAll(this.propertyAttributeExtractor.extractFrom((AccountAttribute)event.abandoner.get(), "abandoner"));
        common.add(this.propertyFactory.create("reason", event.reason));
        return this.extractFrom((PatchSetEvent)event, common);
    }

    private Map<String, Set<String>> extractFrom(ChangeMergedEvent event, Set<Property> common) {
        common.addAll(this.propertyAttributeExtractor.extractFrom((AccountAttribute)event.submitter.get(), "submitter"));
        return this.extractFrom((PatchSetEvent)event, common);
    }

    private Map<String, Set<String>> extractFrom(ChangeRestoredEvent event, Set<Property> common) {
        common.addAll(this.propertyAttributeExtractor.extractFrom((AccountAttribute)event.restorer.get(), "restorer"));
        common.add(this.propertyFactory.create("reason", event.reason));
        return this.extractFrom((PatchSetEvent)event, common);
    }

    private Map<String, Set<String>> extractFrom(DraftPublishedEvent event, Set<Property> common) {
        common.addAll(this.propertyAttributeExtractor.extractFrom((AccountAttribute)event.uploader.get(), "uploader"));
        return this.extractFrom((PatchSetEvent)event, common);
    }

    private Map<String, Set<String>> extractFrom(RefUpdatedEvent event, Set<Property> common) {
        common.add(this.propertyFactory.create("event-type", event.type));
        common.addAll(this.propertyAttributeExtractor.extractFrom((AccountAttribute)event.submitter.get(), "submitter"));
        common.addAll(this.propertyAttributeExtractor.extractFrom((RefUpdateAttribute)event.refUpdate.get()));
        return this.issueExtractor.getIssueIds(event.getProjectNameKey().get(), ((RefUpdateAttribute)event.refUpdate.get()).newRev);
    }

    private Map<String, Set<String>> extractFrom(PatchSetCreatedEvent event, Set<Property> common) {
        common.addAll(this.propertyAttributeExtractor.extractFrom((AccountAttribute)event.uploader.get(), "uploader"));
        return this.extractFrom((PatchSetEvent)event, common);
    }

    private Map<String, Set<String>> extractFrom(CommentAddedEvent event, Set<Property> common) {
        common.addAll(this.propertyAttributeExtractor.extractFrom((AccountAttribute)event.author.get(), "commenter"));
        if (event.approvals != null) {
            for (ApprovalAttribute approvalAttribute : (ApprovalAttribute[])event.approvals.get()) {
                common.addAll(this.propertyAttributeExtractor.extractFrom(approvalAttribute));
            }
        }
        common.add(this.propertyFactory.create("comment", event.comment));
        return this.extractFrom((PatchSetEvent)event, common);
    }

    public Set<Set<Property>> extractFrom(Event event) {
        Map<String, Set<String>> associations = null;
        HashSet ret = Sets.newHashSet();
        HashSet common = Sets.newHashSet();
        common.add(this.propertyFactory.create("event", event.getClass().getName()));
        if (event instanceof ChangeAbandonedEvent) {
            associations = this.extractFrom((ChangeAbandonedEvent)event, (Set<Property>)common);
        } else if (event instanceof ChangeMergedEvent) {
            associations = this.extractFrom((ChangeMergedEvent)event, (Set<Property>)common);
        } else if (event instanceof ChangeRestoredEvent) {
            associations = this.extractFrom((ChangeRestoredEvent)event, (Set<Property>)common);
        } else if (event instanceof CommentAddedEvent) {
            associations = this.extractFrom((CommentAddedEvent)event, (Set<Property>)common);
        } else if (event instanceof DraftPublishedEvent) {
            associations = this.extractFrom((DraftPublishedEvent)event, (Set<Property>)common);
        } else if (event instanceof PatchSetCreatedEvent) {
            associations = this.extractFrom((PatchSetCreatedEvent)event, (Set<Property>)common);
        } else if (event instanceof RefUpdatedEvent) {
            associations = this.extractFrom((RefUpdatedEvent)event, (Set<Property>)common);
        }
        if (associations != null) {
            for (String issue : associations.keySet()) {
                HashSet properties = Sets.newHashSet();
                Property property = this.propertyFactory.create("issue", issue);
                properties.add(property);
                property = this.propertyFactory.create("its-name", this.pluginName);
                properties.add(property);
                for (String occurrence : associations.get(issue)) {
                    property = this.propertyFactory.create("association", occurrence);
                    properties.add(property);
                }
                properties.addAll(common);
                ret.add(properties);
            }
        }
        return ret;
    }
}

