/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.its.base.util;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.its.base.its.ItsConfig;
import com.googlesource.gerrit.plugins.its.base.util.CommitMessageFetcher;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueExtractor {
    private static final Logger log = LoggerFactory.getLogger(IssueExtractor.class);
    private final CommitMessageFetcher commitMessageFetcher;
    private final ReviewDb db;
    private final ItsConfig itsConfig;

    @Inject
    IssueExtractor(ItsConfig itsConfig, CommitMessageFetcher commitMessageFetcher, ReviewDb db) {
        this.commitMessageFetcher = commitMessageFetcher;
        this.db = db;
        this.itsConfig = itsConfig;
    }

    public String[] getIssueIds(String haystack) {
        Pattern pattern = this.itsConfig.getIssuePattern();
        if (pattern == null) {
            return new String[0];
        }
        log.debug("Matching '" + haystack + "' against " + pattern.pattern());
        HashSet issues = Sets.newHashSet();
        Matcher matcher = pattern.matcher(haystack);
        int groupIdx = this.itsConfig.getIssuePatternGroupIndex();
        while (matcher.find()) {
            String issueId = matcher.group(groupIdx);
            if (Strings.isNullOrEmpty((String)issueId)) continue;
            issues.add(issueId);
        }
        return issues.toArray(new String[issues.size()]);
    }

    private void addIssuesOccurrence(String text, String occurrence, Map<String, Set<String>> map) {
        for (String issue : this.getIssueIds(text)) {
            LinkedHashSet occurrences = map.get(issue);
            if (occurrences == null) {
                occurrences = Sets.newLinkedHashSet();
                map.put(issue, occurrences);
            }
            occurrences.add(occurrence);
        }
    }

    public Map<String, Set<String>> getIssueIds(String projectName, String commitId) {
        HashMap ret = Maps.newHashMap();
        String commitMessage = this.commitMessageFetcher.fetchGuarded(projectName, commitId);
        this.addIssuesOccurrence(commitMessage, "somewhere", ret);
        Object[] lines = commitMessage.split("\n");
        if (lines.length > 0) {
            int currentLine;
            this.addIssuesOccurrence(lines[0], "subject", ret);
            for (currentLine = lines.length - 1; currentLine >= 0 && lines[currentLine].isEmpty(); --currentLine) {
            }
            int footerEnd = currentLine + 1;
            while (currentLine >= 0 && !lines[currentLine].isEmpty()) {
                --currentLine;
            }
            int footerStart = currentLine + 1;
            if (footerStart == 0) {
                footerStart = -1;
            }
            String body = null;
            String footer = null;
            if (footerStart == -1) {
                if (lines.length > 0) {
                    body = StringUtils.join((Object[])lines, (String)"\n", (int)1, (int)lines.length);
                }
            } else {
                body = StringUtils.join((Object[])lines, (String)"\n", (int)1, (int)(footerStart - 1));
                StringBuilder footerBuilder = new StringBuilder();
                for (int lineIdx = footerStart; lineIdx < footerEnd; ++lineIdx) {
                    Object line = lines[lineIdx];
                    int colonIdx = ((String)line).indexOf(58);
                    if (colonIdx > 0) {
                        String tag = ((String)line).substring(0, colonIdx);
                        this.addIssuesOccurrence((String)line, "footer-" + tag, ret);
                    }
                    if (lineIdx > footerStart) {
                        footerBuilder.append('\n');
                    }
                    footerBuilder.append((String)line);
                }
                footer = StringUtils.join((Object[])lines, (String)"\n", (int)footerStart, (int)footerEnd);
            }
            if (body != null) {
                this.addIssuesOccurrence(body, "body", ret);
            }
            if (footer != null) {
                this.addIssuesOccurrence(footer, "footer", ret);
            }
        }
        return ret;
    }

    public Map<String, Set<String>> getIssueIds(String projectName, String commitId, PatchSet.Id patchSetId) {
        Map<String, Set<String>> current = this.getIssueIds(projectName, commitId);
        if (patchSetId != null) {
            Map<Object, Object> previous = Maps.newHashMap();
            if (patchSetId.get() != 1) {
                PatchSet.Id previousPatchSetId = new PatchSet.Id(patchSetId.getParentKey(), patchSetId.get() - 1);
                try {
                    PatchSet previousPatchSet = this.db.patchSets().get(previousPatchSetId);
                    if (previousPatchSet != null) {
                        previous = this.getIssueIds(projectName, previousPatchSet.getRevision().get());
                    }
                }
                catch (OrmException previousPatchSet) {
                    // empty catch block
                }
            }
            for (String issue : current.keySet()) {
                HashSet newOccurrences;
                Set<String> currentOccurrences = current.get(issue);
                Set previousOccurrences = (Set)previous.get(issue);
                if (previousOccurrences == null || previousOccurrences.isEmpty()) {
                    newOccurrences = Sets.newHashSet(currentOccurrences);
                } else {
                    newOccurrences = Sets.newHashSet(currentOccurrences);
                    newOccurrences.removeAll(previousOccurrences);
                }
                for (String occurrence : newOccurrences) {
                    currentOccurrences.add("added@" + occurrence);
                }
            }
        }
        return current;
    }
}

