/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.its.base.its;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.RefConfigSection;
import com.google.gerrit.pgm.init.api.AllProjectsConfig;
import com.google.gerrit.pgm.init.api.AllProjectsNameOnInitProvider;
import com.google.gerrit.pgm.init.api.ConsoleUI;
import com.google.gerrit.pgm.init.api.InitStep;
import com.google.gerrit.pgm.init.api.Section;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;

public class InitIts
implements InitStep {
    public static String COMMENT_LINK_SECTION = "commentlink";
    private final String pluginName;
    private final String itsDisplayName;
    protected final ConsoleUI ui;
    private final AllProjectsConfig allProjectsConfig;
    private final AllProjectsNameOnInitProvider allProjects;

    public InitIts(String pluginName, String itsDisplayName, ConsoleUI ui, AllProjectsConfig allProjectsConfig, AllProjectsNameOnInitProvider allProjects) {
        this.pluginName = pluginName;
        this.itsDisplayName = itsDisplayName;
        this.ui = ui;
        this.allProjectsConfig = allProjectsConfig;
        this.allProjects = allProjects;
    }

    public void run() throws IOException, ConfigInvalidException {
    }

    public void postRun() throws IOException, ConfigInvalidException {
        Config cfg = this.allProjectsConfig.load().getConfig();
        this.ui.message("\n", new Object[0]);
        this.ui.header(this.itsDisplayName + " Integration", new Object[0]);
        String enabled = cfg.getString("plugin", this.pluginName, "enabled");
        ItsIntegration itsintegration = ItsIntegration.ENFORCED.name().equalsIgnoreCase(enabled) ? ItsIntegration.ENFORCED : (Boolean.parseBoolean(enabled) ? ItsIntegration.ENABLED : ItsIntegration.DISABLED);
        itsintegration = (ItsIntegration)this.ui.readEnum((Enum)itsintegration, "Issue tracker integration for all projects?", new Object[0]);
        switch (itsintegration) {
            case ENFORCED: {
                cfg.setString("plugin", this.pluginName, "enabled", "enforced");
                this.configureBranches(cfg);
                break;
            }
            case ENABLED: {
                cfg.setBoolean("plugin", this.pluginName, "enabled", true);
                this.configureBranches(cfg);
                break;
            }
            case DISABLED: {
                cfg.unset("plugin", this.pluginName, "enabled");
                break;
            }
            default: {
                throw new IOException("Unsupported value for issue track integration: " + itsintegration.name());
            }
        }
        this.allProjectsConfig.save(this.pluginName, "Initialize " + this.itsDisplayName + " Integration");
    }

    private void configureBranches(Config cfg) {
        boolean validRef;
        String branch;
        String[] branches = cfg.getStringList("plugin", this.pluginName, "branch");
        if (branches.length > 1) {
            this.ui.message("The issue tracker integration is configured for multiple branches. Please adapt the configuration in the 'project.config' file of the '%s' project.\n", new Object[]{this.allProjects.get()});
            return;
        }
        String string = branch = branches.length == 1 ? branches[0] : null;
        if (Strings.isNullOrEmpty((String)branch)) {
            branch = "refs/heads/*";
        }
        do {
            String v;
            if (validRef = RefConfigSection.isValid((String)(v = this.ui.readString(branch, "Branches for which the issue tracker integration should be enabled (ref, ref pattern or regular expression)", new Object[0])))) {
                branch = v;
                continue;
            }
            this.ui.message("'%s' is not valid. Please specify a valid ref, ref pattern or regular expression\n", new Object[]{v});
        } while (!validRef);
        cfg.setString("plugin", this.pluginName, "branch", branch);
    }

    public boolean isConnectivityRequested(String url) {
        return this.ui.yesno(Boolean.valueOf(false), "Test connectivity to %s", new Object[]{url});
    }

    public boolean enterSSLVerify(Section section) {
        return TrueFalseEnum.TRUE == section.select("Verify SSL Certificates", "sslVerify", (Enum)TrueFalseEnum.TRUE);
    }

    public static enum ItsIntegration {
        ENABLED,
        DISABLED,
        ENFORCED;

    }

    public static enum TrueFalseEnum {
        TRUE,
        FALSE;

    }
}

