/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.its.storyboard;

import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.hooks.its.ItsFacade;
import com.googlesource.gerrit.plugins.its.storyboard.StoryboardClient;
import java.io.IOException;
import java.net.URL;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoryboardItsFacade
implements ItsFacade {
    private final Logger log = LoggerFactory.getLogger(StoryboardItsFacade.class);
    private static final String GERRIT_CONFIG_USERNAME = "username";
    private static final String GERRIT_CONFIG_PASSWORD = "password";
    private static final String GERRIT_CONFIG_URL = "url";
    private final StoryboardClient client;

    @Inject
    public StoryboardItsFacade(@PluginName String pluginName, @GerritServerConfig Config cfg) {
        String url = cfg.getString(pluginName, null, GERRIT_CONFIG_URL);
        String username = cfg.getString(pluginName, null, GERRIT_CONFIG_USERNAME);
        String password = cfg.getString(pluginName, null, GERRIT_CONFIG_PASSWORD);
        this.client = new StoryboardClient(url, username, password);
    }

    @Override
    public String healthCheck(ItsFacade.Check check) throws IOException {
        return "unknown";
    }

    @Override
    public void addComment(String issueId, String comment) {
        if (!this.exists(issueId)) {
            this.log.warn("Story " + issueId + " does not exist, nothing to update");
            return;
        }
        try {
            this.client.addComment(issueId, comment);
        }
        catch (IOException e) {
            this.log.error("Error: could not add comment to issue " + issueId);
        }
        this.log.info("Updated " + issueId + "with comment: " + comment);
    }

    @Override
    public void addRelatedLink(String issueId, URL relatedUrl, String description) throws IOException {
        this.addComment(issueId, "Related URL: " + this.createLinkForWebui(relatedUrl.toExternalForm(), description));
    }

    @Override
    public void performAction(String issueId, String actionString) {
    }

    @Override
    public boolean exists(String issudeId) {
        String info = null;
        try {
            info = this.client.getStory(issudeId);
        }
        catch (IOException e) {
            this.log.error("Error: Storyboard is not accessible");
        }
        if (info != null) {
            this.log.debug("Story exists, info: " + info);
            return true;
        }
        return false;
    }

    @Override
    public String createLinkForWebui(String url, String text) {
        if (text != null && !text.isEmpty() && !text.equals(url)) {
            return "[" + text + "]" + "(" + url + ")";
        }
        return url;
    }
}

