/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.workflow;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.server.config.SitePath;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.hooks.workflow.ActionRequest;
import com.googlesource.gerrit.plugins.hooks.workflow.Condition;
import com.googlesource.gerrit.plugins.hooks.workflow.Property;
import com.googlesource.gerrit.plugins.hooks.workflow.Rule;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBase {
    private static final Logger log = LoggerFactory.getLogger(RuleBase.class);
    private static final String ITS_CONFIG_FILE_START = "etc" + File.separatorChar + "its" + File.separator + "actions";
    private static final String ITS_CONFIG_FILE_END = ".config";
    private static final String RULE_SECTION = "rule";
    private static final String ACTION_KEY = "action";
    private final File sitePath;
    private final Rule.Factory ruleFactory;
    private final Condition.Factory conditionFactory;
    private final ActionRequest.Factory actionRequestFactory;
    private final String pluginName;
    private Collection<Rule> rules;

    @Inject
    public RuleBase(@SitePath File sitePath, Rule.Factory ruleFactory, Condition.Factory conditionFactory, ActionRequest.Factory actionRequestFactory, @PluginName String pluginName) {
        this.sitePath = sitePath;
        this.ruleFactory = ruleFactory;
        this.conditionFactory = conditionFactory;
        this.actionRequestFactory = actionRequestFactory;
        this.pluginName = pluginName;
        this.reloadRules();
    }

    private void addRulesFromFile(File ruleFile) {
        if (ruleFile.exists()) {
            FileBasedConfig cfg = new FileBasedConfig(ruleFile, FS.DETECTED);
            try {
                cfg.load();
            }
            catch (IOException | ConfigInvalidException e) {
                log.error("Invalid ITS action configuration", e);
                return;
            }
            Set subsections = cfg.getSubsections(RULE_SECTION);
            for (String subsection : subsections) {
                Rule rule = this.ruleFactory.create(subsection);
                Set keys = cfg.getNames(RULE_SECTION, subsection);
                for (String key : keys) {
                    String[] values = cfg.getStringList(RULE_SECTION, subsection, key);
                    if (ACTION_KEY.equals(key)) {
                        for (String value : values) {
                            ActionRequest actionRequest = this.actionRequestFactory.create(value);
                            rule.addActionRequest(actionRequest);
                        }
                        continue;
                    }
                    for (String value : values) {
                        Condition condition = this.conditionFactory.create(key, value);
                        rule.addCondition(condition);
                    }
                }
                this.rules.add(rule);
            }
        }
    }

    private void reloadRules() {
        this.rules = Lists.newArrayList();
        File faultyNameRuleFile = new File(this.sitePath, "etc" + File.separatorChar + "its" + File.separator + "action.config");
        if (faultyNameRuleFile.exists()) {
            log.warn("Loading rules from deprecated 'etc/its/action.config' (No trailing 's' in 'action'). Please migrate to 'etc/its/actions.config' (Trailing 's' in 'actions').");
            this.addRulesFromFile(faultyNameRuleFile);
        }
        File globalRuleFile = new File(this.sitePath, ITS_CONFIG_FILE_START + ITS_CONFIG_FILE_END);
        this.addRulesFromFile(globalRuleFile);
        File itsSpecificRuleFile = new File(this.sitePath, ITS_CONFIG_FILE_START + "-" + this.pluginName + ITS_CONFIG_FILE_END);
        this.addRulesFromFile(itsSpecificRuleFile);
        if (!globalRuleFile.exists() && !itsSpecificRuleFile.exists()) {
            try {
                log.warn("Neither global rule file " + globalRuleFile.getCanonicalPath() + " nor Its specific rule file" + itsSpecificRuleFile.getCanonicalPath() + " exist. Please configure " + "rules.");
            }
            catch (IOException e) {
                log.warn("Neither global rule file nor Its specific rule files exist. Please configure rules.");
            }
        }
    }

    public Collection<ActionRequest> actionRequestsFor(Iterable<Property> properties) {
        LinkedList ret = Lists.newLinkedList();
        for (Rule rule : this.rules) {
            ret.addAll(rule.actionRequestsFor(properties));
        }
        return ret;
    }

    public static interface Factory {
        public RuleBase create();
    }
}

