/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.workflow;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.events.PatchSetCreatedEvent;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.hooks.its.ItsFacade;
import com.googlesource.gerrit.plugins.hooks.util.IssueExtractor;
import com.googlesource.gerrit.plugins.hooks.workflow.GerritHookFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritHookFilterAddRelatedLinkToChangeId
extends GerritHookFilter {
    Logger log = LoggerFactory.getLogger(GerritHookFilterAddRelatedLinkToChangeId.class);
    @Inject
    private ItsFacade its;
    @Inject
    @GerritServerConfig
    private Config gerritConfig;
    @Inject
    private IssueExtractor issueExtractor;
    @Inject
    private ReviewDb db;
    @Inject
    @PluginName
    private String pluginName;

    private List<String> filterForFirstLinkedIssues(String[] issues, PatchSetCreatedEvent patchSet) throws IOException, OrmException {
        ArrayList ret = Lists.newArrayList((Object[])issues);
        int patchSetNumberCurrent = Integer.parseInt(patchSet.patchSet.number);
        if (patchSetNumberCurrent > 1) {
            String project = patchSet.change.project;
            int changeNumber = Integer.parseInt(patchSet.change.number);
            Change.Id changeId = new Change.Id(changeNumber);
            ResultSet patchSets = this.db.patchSets().byChange(changeId);
            Iterator patchSetIter = patchSets.iterator();
            while (!ret.isEmpty() && patchSetIter.hasNext()) {
                PatchSet previousPatchSet = (PatchSet)patchSetIter.next();
                if (previousPatchSet.getPatchSetId() >= patchSetNumberCurrent) continue;
                String commitMessage = this.getComment(project, previousPatchSet.getRevision().get());
                for (String issue : this.issueExtractor.getIssueIds(commitMessage)) {
                    ret.remove(issue);
                }
            }
        }
        return ret;
    }

    @Override
    public void doFilter(PatchSetCreatedEvent patchsetCreated) throws IOException, OrmException {
        boolean addPatchSetComment = this.gerritConfig.getBoolean(this.pluginName, null, "commentOnPatchSetCreated", true);
        boolean addChangeComment = "1".equals(patchsetCreated.patchSet.number) && this.gerritConfig.getBoolean(this.pluginName, null, "commentOnChangeCreated", false);
        boolean addFirstLinkedPatchSetComment = this.gerritConfig.getBoolean(this.pluginName, null, "commentOnFirstLinkedPatchSetCreated", false);
        if (addPatchSetComment || addFirstLinkedPatchSetComment || addChangeComment) {
            String gitComment = this.getComment(patchsetCreated.change.project, patchsetCreated.patchSet.revision);
            String[] issues = this.issueExtractor.getIssueIds(gitComment);
            List<String> firstLinkedIssues = null;
            if (addFirstLinkedPatchSetComment) {
                firstLinkedIssues = this.filterForFirstLinkedIssues(issues, patchsetCreated);
            }
            for (String issue : issues) {
                if (addChangeComment) {
                    this.its.addRelatedLink(issue, new URL(patchsetCreated.change.url), "Gerrit Change " + patchsetCreated.change.id);
                }
                if (addPatchSetComment) {
                    this.its.addRelatedLink(issue, new URL(patchsetCreated.change.url), "Gerrit Patch-Set " + patchsetCreated.change.id + "/" + patchsetCreated.patchSet.number);
                }
                if (!addFirstLinkedPatchSetComment || !firstLinkedIssues.contains(issue)) continue;
                this.its.addRelatedLink(issue, new URL(patchsetCreated.change.url), "Gerrit Patch-Set " + patchsetCreated.change.id + "/" + patchsetCreated.patchSet.number);
            }
        }
    }
}

