/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.workflow;

import com.google.gerrit.common.EventListener;
import com.google.gerrit.server.events.ChangeAbandonedEvent;
import com.google.gerrit.server.events.ChangeMergedEvent;
import com.google.gerrit.server.events.ChangeRestoredEvent;
import com.google.gerrit.server.events.CommentAddedEvent;
import com.google.gerrit.server.events.Event;
import com.google.gerrit.server.events.PatchSetCreatedEvent;
import com.google.gerrit.server.events.RefUpdatedEvent;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.hooks.its.ItsConfig;
import com.googlesource.gerrit.plugins.hooks.util.CommitMessageFetcher;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritHookFilter
implements EventListener {
    private static final Logger log = LoggerFactory.getLogger(GerritHookFilter.class);
    @Inject
    private CommitMessageFetcher commitMessageFetcher;
    @Inject
    private ItsConfig itsConfig;

    public String getComment(String projectName, String commitId) throws IOException {
        return this.commitMessageFetcher.fetch(projectName, commitId);
    }

    public void doFilter(PatchSetCreatedEvent hook) throws IOException, OrmException {
    }

    public void doFilter(CommentAddedEvent hook) throws IOException {
    }

    public void doFilter(ChangeMergedEvent hook) throws IOException {
    }

    public void doFilter(ChangeAbandonedEvent changeAbandonedHook) throws IOException {
    }

    public void doFilter(ChangeRestoredEvent changeRestoredHook) throws IOException {
    }

    public void doFilter(RefUpdatedEvent refUpdatedHook) throws IOException {
    }

    public void onEvent(Event event) {
        if (!this.itsConfig.isEnabled(event)) {
            return;
        }
        try {
            if (event instanceof PatchSetCreatedEvent) {
                this.doFilter((PatchSetCreatedEvent)event);
            } else if (event instanceof CommentAddedEvent) {
                this.doFilter((CommentAddedEvent)event);
            } else if (event instanceof ChangeMergedEvent) {
                this.doFilter((ChangeMergedEvent)event);
            } else if (event instanceof ChangeAbandonedEvent) {
                this.doFilter((ChangeAbandonedEvent)event);
            } else if (event instanceof ChangeRestoredEvent) {
                this.doFilter((ChangeRestoredEvent)event);
            } else if (event instanceof RefUpdatedEvent) {
                this.doFilter((RefUpdatedEvent)event);
            } else {
                log.debug("Event " + event + " not recognised and ignored");
            }
        }
        catch (Throwable e) {
            log.error("Event " + event + " processing failed", e);
        }
    }

    public String getUrl(PatchSetCreatedEvent hook) {
        return null;
    }
}

