/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.hooks.its;

import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.config.PluginConfigFactory;
import com.google.gerrit.server.config.ProjectConfigEntry;
import com.google.gerrit.server.project.ProjectState;
import java.util.Arrays;

public class ItsHookEnabledConfigEntry
extends ProjectConfigEntry {
    private final String pluginName;
    private final PluginConfigFactory pluginCfgFactory;

    public ItsHookEnabledConfigEntry(String pluginName, PluginConfigFactory pluginCfgFactory) {
        super("Enable " + pluginName + " integration", "false", Arrays.asList("false", "true", "enforced"), true);
        this.pluginName = pluginName;
        this.pluginCfgFactory = pluginCfgFactory;
    }

    public boolean isEditable(ProjectState project) {
        for (ProjectState parentState : project.parents()) {
            PluginConfig parentCfg = this.pluginCfgFactory.getFromProjectConfig(parentState, this.pluginName);
            if (!"enforced".equals(parentCfg.getString("enabled"))) continue;
            return false;
        }
        return true;
    }
}

