// Copyright (C) 2015 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.googlesource.gerrit.plugins.importer.client;

import com.google.gwt.core.client.JavaScriptObject;

public class ImportProjectInput extends JavaScriptObject {
  final native void from(String f) /*-{ this.from = f; }-*/;
  final native void name(String n) /*-{ this.name = n; }-*/;
  final native void user(String u) /*-{ this.user = u; }-*/;
  final native void pass(String p) /*-{ this.pass = p; }-*/;
  final native void parent(String p) /*-{ this.parent = p; }-*/;

  static ImportProjectInput create() {
    return (ImportProjectInput) createObject();
  }

  protected ImportProjectInput() {
  }
}
