/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject.database;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.StarredChangesUtil;
import com.google.gerrit.server.change.AccountPatchReviewStore;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeOpRepoManager;
import com.google.gerrit.server.git.SubmoduleOp;
import com.google.gerrit.server.index.change.ChangeIndexer;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.googlesource.gerrit.plugins.deleteproject.CannotDeleteProjectException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseDeleteHandler {
    private static final Logger log = LoggerFactory.getLogger(DatabaseDeleteHandler.class);
    private final ReviewDb db;
    private final Provider<InternalChangeQuery> queryProvider;
    private final GitRepositoryManager repoManager;
    private final SubmoduleOp.Factory subOpFactory;
    private final Provider<MergeOpRepoManager> ormProvider;
    private final StarredChangesUtil starredChangesUtil;
    private final DynamicItem<AccountPatchReviewStore> accountPatchReviewStore;
    private final ChangeIndexer indexer;

    @Inject
    public DatabaseDeleteHandler(ReviewDb db, Provider<InternalChangeQuery> queryProvider, GitRepositoryManager repoManager, SubmoduleOp.Factory subOpFactory, Provider<MergeOpRepoManager> ormProvider, StarredChangesUtil starredChangesUtil, DynamicItem<AccountPatchReviewStore> accountPatchReviewStore, ChangeIndexer indexer) {
        this.db = ReviewDbUtil.unwrapDb((ReviewDb)db);
        this.queryProvider = queryProvider;
        this.repoManager = repoManager;
        this.subOpFactory = subOpFactory;
        this.ormProvider = ormProvider;
        this.starredChangesUtil = starredChangesUtil;
        this.accountPatchReviewStore = accountPatchReviewStore;
        this.indexer = indexer;
    }

    public Collection<String> getWarnings(Project project) throws OrmException {
        ArrayList ret = Lists.newArrayList();
        List openChanges = ((InternalChangeQuery)this.queryProvider.get()).byProjectOpen(project.getNameKey());
        if (openChanges.iterator().hasNext()) {
            ret.add(project.getName() + " has open changes");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Project project) throws OrmException {
        Connection conn = ((JdbcSchema)this.db).getConnection();
        try {
            conn.setAutoCommit(false);
            try {
                this.atomicDelete(project);
                conn.commit();
            }
            finally {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                throw new OrmException((Throwable)ex);
            }
            throw new OrmException((Throwable)e);
        }
    }

    private final void deleteChanges(List<ChangeData> changeData) throws OrmException {
        for (ChangeData cd : changeData) {
            Change.Id id = cd.getId();
            ResultSet patchSets = null;
            patchSets = this.db.patchSets().byChange(id);
            if (patchSets != null) {
                this.deleteFromPatchSets((ResultSet<PatchSet>)patchSets);
            }
            this.db.patchComments().delete((Iterable)this.db.patchComments().byChange(id));
            this.db.patchSetApprovals().delete((Iterable)this.db.patchSetApprovals().byChange(id));
            try {
                this.starredChangesUtil.unstarAll(cd.project(), id);
            }
            catch (NoSuchChangeException noSuchChangeException) {
                // empty catch block
            }
            this.db.changeMessages().delete((Iterable)this.db.changeMessages().byChange(id));
            this.db.changes().delete(Collections.singleton(cd.change()));
            try {
                this.indexer.delete(id);
            }
            catch (IOException e) {
                log.error(String.format("Failed to delete change %s from index", id), (Throwable)e);
            }
        }
    }

    private final void deleteFromPatchSets(ResultSet<PatchSet> patchSets) throws OrmException {
        for (PatchSet patchSet : patchSets) {
            ((AccountPatchReviewStore)this.accountPatchReviewStore.get()).clearReviewed(patchSet.getId());
            this.db.patchSets().delete(Collections.singleton(patchSet));
        }
    }

    public void assertCanDelete(Project project) throws CannotDeleteProjectException {
        Project.NameKey proj = project.getNameKey();
        try (Repository repo2 = this.repoManager.openRepository(proj);
             MergeOpRepoManager orm = (MergeOpRepoManager)this.ormProvider.get();){
            HashSet<Branch.NameKey> branches = new HashSet<Branch.NameKey>();
            for (Ref ref : repo2.getRefDatabase().getRefs("refs/heads/").values()) {
                branches.add(new Branch.NameKey(proj, ref.getName()));
            }
            SubmoduleOp sub = this.subOpFactory.create(branches, orm);
            for (Branch.NameKey b : branches) {
                if (sub.superProjectSubscriptionsForSubmoduleBranch(b).isEmpty()) continue;
                throw new CannotDeleteProjectException("Project is subscribed by other projects.");
            }
        }
        catch (RepositoryNotFoundException repo2) {
        }
        catch (IOException e) {
            throw new CannotDeleteProjectException("Project is subscribed by other projects.");
        }
    }

    public void atomicDelete(Project project) throws OrmException {
        List changes = ((InternalChangeQuery)this.queryProvider.get()).byProject(project.getNameKey());
        this.deleteChanges(changes);
        this.db.accountProjectWatches().delete((Iterable)this.db.accountProjectWatches().byProject(project.getNameKey()));
    }
}

