/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject;

import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.CapabilityControl;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AllProjectsNameProvider;
import com.google.gerrit.server.config.PluginConfigFactory;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.googlesource.gerrit.plugins.deleteproject.CannotDeleteProjectException;
import com.googlesource.gerrit.plugins.deleteproject.DeleteLog;
import com.googlesource.gerrit.plugins.deleteproject.HideProject;
import com.googlesource.gerrit.plugins.deleteproject.cache.CacheDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.database.DatabaseDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.fs.FilesystemDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.projectconfig.ProjectConfigDeleteHandler;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.errors.RepositoryNotFoundException;

class DeleteProject
implements RestModifyView<ProjectResource, Input> {
    protected final AllProjectsName allProjectsName;
    private final DatabaseDeleteHandler dbHandler;
    private final FilesystemDeleteHandler fsHandler;
    private final CacheDeleteHandler cacheHandler;
    private final ProjectConfigDeleteHandler pcHandler;
    private final Provider<CurrentUser> userProvider;
    private final String pluginName;
    private final DeleteLog deleteLog;
    private final PluginConfigFactory cfgFactory;
    private final HideProject hideProject;

    @Inject
    DeleteProject(AllProjectsNameProvider allProjectsNameProvider, DatabaseDeleteHandler dbHandler, FilesystemDeleteHandler fsHandler, CacheDeleteHandler cacheHandler, ProjectConfigDeleteHandler pcHandler, Provider<CurrentUser> userProvider, @PluginName String pluginName, DeleteLog deleteLog, PluginConfigFactory cfgFactory, HideProject hideProject) {
        this.allProjectsName = allProjectsNameProvider.get();
        this.dbHandler = dbHandler;
        this.fsHandler = fsHandler;
        this.cacheHandler = cacheHandler;
        this.pcHandler = pcHandler;
        this.userProvider = userProvider;
        this.pluginName = pluginName;
        this.deleteLog = deleteLog;
        this.cfgFactory = cfgFactory;
        this.hideProject = hideProject;
    }

    public Object apply(ProjectResource rsrc, Input input) throws ResourceNotFoundException, ResourceConflictException, OrmException, IOException, AuthException {
        Collection<String> warnings;
        this.assertDeletePermission(rsrc);
        this.assertCanDelete(rsrc, input);
        if (!(input != null && input.force || (warnings = this.getWarnings(rsrc)).isEmpty())) {
            throw new ResourceConflictException(String.format("Project %s has open changes", rsrc.getName()));
        }
        this.doDelete(rsrc, input);
        return Response.none();
    }

    public void assertDeletePermission(ProjectResource rsrc) throws AuthException {
        if (!this.canDelete(rsrc)) {
            throw new AuthException("not allowed to delete project");
        }
    }

    protected boolean canDelete(ProjectResource rsrc) {
        CapabilityControl ctl = ((CurrentUser)this.userProvider.get()).getCapabilities();
        return ctl.canAdministrateServer() || ctl.canPerform(this.pluginName + "-" + "deleteProject") || ctl.canPerform(this.pluginName + "-" + "deleteOwnProject") && rsrc.getControl().isOwner();
    }

    public void assertCanDelete(ProjectResource rsrc, Input input) throws ResourceConflictException {
        try {
            this.pcHandler.assertCanDelete(rsrc);
            this.dbHandler.assertCanDelete(rsrc.getControl().getProject());
            this.fsHandler.assertCanDelete(rsrc, input == null ? false : input.preserve);
        }
        catch (CannotDeleteProjectException e) {
            throw new ResourceConflictException(e.getMessage());
        }
    }

    public Collection<String> getWarnings(ProjectResource rsrc) throws OrmException {
        return this.dbHandler.getWarnings(rsrc.getControl().getProject());
    }

    public void doDelete(ProjectResource rsrc, Input input) throws OrmException, IOException, ResourceNotFoundException, ResourceConflictException {
        block8: {
            Project project = rsrc.getControl().getProject();
            boolean preserve = input != null && input.preserve;
            Exception ex = null;
            try {
                if (!preserve || !this.cfgFactory.getFromGerritConfig(this.pluginName).getBoolean("hideProjectOnPreserve", false)) {
                    this.dbHandler.delete(project);
                    try {
                        this.fsHandler.delete(project, preserve);
                    }
                    catch (RepositoryNotFoundException e) {
                        throw new ResourceNotFoundException();
                    }
                    this.cacheHandler.delete(project);
                    break block8;
                }
                this.hideProject.apply(rsrc);
            }
            catch (Exception e) {
                ex = e;
                throw e;
            }
            finally {
                this.deleteLog.onDelete((IdentifiedUser)this.userProvider.get(), project.getNameKey(), input, ex);
            }
        }
    }

    static class Input {
        boolean preserve;
        boolean force;

        Input() {
        }
    }
}

