/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.deleteproject.DeleteProject;
import java.io.IOException;
import java.util.Collection;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@CommandMetaData(name="delete", description="Delete specific project")
public final class DeleteCommand
extends SshCommand {
    @Argument(index=0, required=true, metaVar="NAME", usage="project to delete")
    private ProjectControl projectControl;
    @Option(name="--yes-really-delete", usage="confirmation to delete the project")
    private boolean yesReallyDelete;
    @Option(name="--force", usage="delete the project even if it has open changes")
    private boolean force = false;
    @Option(name="--preserve-git-repository", usage="don't delete git repository directory")
    private boolean preserveGitRepository = false;
    private final DeleteProject deleteProject;

    @Inject
    protected DeleteCommand(DeleteProject deleteProject) {
        this.deleteProject = deleteProject;
    }

    public void run() throws BaseCommand.Failure {
        try {
            Collection<String> warnings;
            DeleteProject.Input input = new DeleteProject.Input();
            input.force = this.force;
            input.preserve = this.preserveGitRepository;
            ProjectResource rsrc = new ProjectResource(this.projectControl);
            this.deleteProject.assertDeletePermission(rsrc);
            this.deleteProject.assertCanDelete(rsrc, input);
            if (!this.yesReallyDelete) {
                StringBuilder msgBuilder = new StringBuilder();
                msgBuilder.append("Really delete ");
                msgBuilder.append(rsrc.getName());
                msgBuilder.append("?\n");
                msgBuilder.append("This is an operation which permanently deletes ");
                msgBuilder.append("data. This cannot be undone!\n");
                msgBuilder.append("If you are sure you wish to delete this project, ");
                msgBuilder.append("re-run\n");
                msgBuilder.append("with the --yes-really-delete flag.\n");
                throw new BaseCommand.UnloggedFailure(msgBuilder.toString());
            }
            if (!this.force && (warnings = this.deleteProject.getWarnings(rsrc)) != null && !warnings.isEmpty()) {
                StringBuilder msgBuilder = new StringBuilder();
                msgBuilder.append("There are warnings against deleting ");
                msgBuilder.append(rsrc.getName());
                msgBuilder.append(":\n");
                for (String warning : warnings) {
                    msgBuilder.append(" * ");
                    msgBuilder.append(warning);
                    msgBuilder.append("\n");
                }
                msgBuilder.append("To really delete ");
                msgBuilder.append(rsrc.getName());
                msgBuilder.append(", re-run with the --force flag.");
                throw new BaseCommand.UnloggedFailure(msgBuilder.toString());
            }
            this.deleteProject.doDelete(rsrc, input);
        }
        catch (AuthException | ResourceConflictException | ResourceNotFoundException | OrmException | IOException e) {
            this.die(e);
        }
    }
}

