/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject.fs;

import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTrashFolders
implements LifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(DeleteTrashFolders.class);
    private File gitDir;

    @Inject
    public DeleteTrashFolders(SitePaths site, @GerritServerConfig Config cfg) {
        this.gitDir = site.resolve(cfg.getString("gerrit", null, "basePath"));
    }

    public void start() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Files.walkFileTree(DeleteTrashFolders.this.gitDir.toPath(), new TrashFolderRemover());
                }
                catch (IOException e) {
                    log.warn("Exception occured while trying to delete trash folders", (Throwable)e);
                }
            }
        }, "DeleteTrashFolders").start();
    }

    public void stop() {
    }

    class TrashFolderRemover
    extends SimpleFileVisitor<Path> {
        TrashFolderRemover() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            String fName = dir.getFileName().toString();
            if (fName.endsWith(".deleted") && fName.matches(".*\\d{13}.deleted$")) {
                log.warn("Will delete this folder: {}", (Object)dir);
                this.recursiveDelete(dir);
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (RepositoryCache.FileKey.isGitRepository((File)dir.toFile(), (FS)FS.DETECTED)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return super.preVisitDirectory(dir, attrs);
        }

        private void recursiveDelete(Path file) throws IOException {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e != null) {
                        throw e;
                    }
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

