/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject.database;

import com.google.common.collect.Lists;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.googlesource.gerrit.plugins.deleteproject.CannotDeleteProjectException;
import com.googlesource.gerrit.plugins.deleteproject.database.DatabaseDeleteHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Schema73DatabaseDeleteHandler
implements DatabaseDeleteHandler {
    private final ReviewDb db;
    private final Provider<InternalChangeQuery> queryProvider;

    @Inject
    public Schema73DatabaseDeleteHandler(ReviewDb db, Provider<InternalChangeQuery> queryProvider) {
        this.db = db;
        this.queryProvider = queryProvider;
    }

    @Override
    public void assertCanDelete(Project project) throws CannotDeleteProjectException, OrmException {
        Connection conn = ((JdbcSchema)this.db).getConnection();
        String projectName = project.getName();
        try {
            if (conn.createStatement().executeQuery("SELECT * FROM submodule_subscriptions WHERE super_project_project_name = '" + projectName + "'").first()) {
                throw new CannotDeleteProjectException("Project has subscribed submodules.");
            }
            if (conn.createStatement().executeQuery("SELECT * FROM submodule_subscriptions WHERE submodule_project_name = '" + projectName + "'").first()) {
                throw new CannotDeleteProjectException("Project is subscribed by other projects.");
            }
        }
        catch (SQLException e) {
            throw new OrmException((Throwable)e);
        }
    }

    @Override
    public Collection<String> getWarnings(Project project) throws OrmException {
        ArrayList ret = Lists.newArrayList();
        List openChanges = ((InternalChangeQuery)this.queryProvider.get()).byProjectOpen(project.getNameKey());
        if (openChanges.iterator().hasNext()) {
            ret.add(project.getName() + " has open changes");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Project project) throws OrmException {
        Connection conn = ((JdbcSchema)this.db).getConnection();
        try {
            conn.setAutoCommit(false);
            try {
                this.atomicDelete(project);
                conn.commit();
            }
            finally {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                throw new OrmException((Throwable)ex);
            }
            throw new OrmException((Throwable)e);
        }
    }

    public void atomicDelete(Project project) throws OrmException {
        List changes = ((InternalChangeQuery)this.queryProvider.get()).byProject(project.getNameKey());
        this.deleteChanges(changes);
        this.db.accountProjectWatches().delete((Iterable)this.db.accountProjectWatches().byProject(project.getNameKey()));
    }

    private final void deleteChanges(List<ChangeData> changeData) throws OrmException {
        for (ChangeData cd : changeData) {
            Change.Id id = cd.getId();
            ResultSet patchSets = null;
            patchSets = this.db.patchSets().byChange(id);
            if (patchSets != null) {
                this.deleteFromPatchSets((ResultSet<PatchSet>)patchSets);
            }
            this.db.patchComments().delete((Iterable)this.db.patchComments().byChange(id));
            this.db.patchSetApprovals().delete((Iterable)this.db.patchSetApprovals().byChange(id));
            this.db.changeMessages().delete((Iterable)this.db.changeMessages().byChange(id));
            this.db.starredChanges().delete((Iterable)this.db.starredChanges().byChange(id));
            this.db.changes().delete(Collections.singleton(cd.change()));
        }
    }

    private final void deleteFromPatchSets(ResultSet<PatchSet> patchSets) throws OrmException {
        for (PatchSet patchSet : patchSets) {
            this.db.patchSetAncestors().delete((Iterable)this.db.patchSetAncestors().byPatchSet(patchSet.getId()));
            this.db.accountPatchReviews().delete((Iterable)this.db.accountPatchReviews().byPatchSet(patchSet.getId()));
            this.db.patchSets().delete(Collections.singleton(patchSet));
        }
    }
}

