/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject.projectconfig;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AllProjectsNameProvider;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.googlesource.gerrit.plugins.deleteproject.CannotDeleteProjectException;

public class ProjectConfigDeleteHandler {
    protected final AllProjectsName allProjectsName;
    private final SitePaths site;

    @Inject
    public ProjectConfigDeleteHandler(SitePaths site, AllProjectsNameProvider allProjectsNameProvider) {
        this.site = site;
        this.allProjectsName = allProjectsNameProvider.get();
    }

    public void assertCanDelete(ProjectResource rsrc) throws CannotDeleteProjectException {
        this.assertIsNotAllProjects(rsrc);
    }

    private void assertIsNotAllProjects(ProjectResource rsrc) throws CannotDeleteProjectException {
        Project project = rsrc.getControl().getProject();
        if (project.getNameKey().equals((Object)this.allProjectsName)) {
            throw new CannotDeleteProjectException("Perhaps you meant to rm -fR " + this.site.site_path);
        }
    }
}

