/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject.fs;

import com.google.gerrit.extensions.events.ProjectDeletedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemDeleteHandler {
    private static final Logger log = LoggerFactory.getLogger(FilesystemDeleteHandler.class);
    private final File gitDir;
    private final GitRepositoryManager repoManager;
    private final DynamicSet<ProjectDeletedListener> deletedListener;

    @Inject
    public FilesystemDeleteHandler(GitRepositoryManager repoManager, SitePaths site, @GerritServerConfig Config cfg, DynamicSet<ProjectDeletedListener> deletedListener) {
        this.gitDir = site.resolve(cfg.getString("gerrit", null, "basePath"));
        this.repoManager = repoManager;
        this.deletedListener = deletedListener;
    }

    public void delete(Project project, boolean preserveGitRepository) throws IOException, RepositoryNotFoundException {
        Repository repository = this.repoManager.openRepository(project.getNameKey());
        if (repository == null) {
            throw new RepositoryNotFoundException("There was an error finding the project.");
        }
        this.cleanCache(repository);
        if (!preserveGitRepository) {
            this.deleteGitRepository(project.getNameKey(), repository);
        }
    }

    private void deleteGitRepository(final Project.NameKey project, Repository repository) throws IOException {
        File parentFile = repository.getDirectory().getParentFile();
        if (!this.recursiveDelete(repository.getDirectory())) {
            throw new IOException("Error trying to delete " + repository.getDirectory().getAbsolutePath());
        }
        this.recursiveDeleteParent(parentFile, this.gitDir);
        ProjectDeletedListener.Event event = new ProjectDeletedListener.Event(){

            public String getProjectName() {
                return project.get();
            }
        };
        for (ProjectDeletedListener l : this.deletedListener) {
            try {
                l.onProjectDeleted(event);
            }
            catch (RuntimeException e) {
                log.warn("Failure in ProjectDeletedListener", (Throwable)e);
            }
        }
    }

    private void cleanCache(Repository repository) {
        repository.close();
        RepositoryCache.close((Repository)repository);
    }

    private boolean recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] contents = file.listFiles();
            if (contents == null) {
                return false;
            }
            for (File f : contents) {
                if (this.recursiveDelete(f)) continue;
                return false;
            }
        }
        return file.delete();
    }

    private void recursiveDeleteParent(File file, File until) {
        if (file.equals(until)) {
            return;
        }
        if (file.listFiles().length == 0) {
            File parent = file.getParentFile();
            file.delete();
            this.recursiveDeleteParent(parent, until);
        }
    }
}

