/*
 * Decompiled with CFR 0.152.
 */
package com.googlesource.gerrit.plugins.deleteproject;

import com.google.gerrit.extensions.annotations.Exports;
import com.google.gerrit.extensions.config.CapabilityDefinition;
import com.google.gerrit.extensions.restapi.RestApiModule;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.inject.AbstractModule;
import com.googlesource.gerrit.plugins.deleteproject.DeleteAction;
import com.googlesource.gerrit.plugins.deleteproject.DeleteOwnProjectCapability;
import com.googlesource.gerrit.plugins.deleteproject.DeleteProject;
import com.googlesource.gerrit.plugins.deleteproject.DeleteProjectCapability;
import com.googlesource.gerrit.plugins.deleteproject.cache.CacheDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.database.DatabaseDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.database.Schema73DatabaseDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.database.Schema77DatabaseDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.fs.FilesystemDeleteHandler;
import com.googlesource.gerrit.plugins.deleteproject.projectconfig.ProjectConfigDeleteHandler;
import java.lang.annotation.Annotation;

public class Module
extends AbstractModule {
    protected void configure() {
        this.bind(CacheDeleteHandler.class);
        this.bind(CapabilityDefinition.class).annotatedWith((Annotation)Exports.named((String)"deleteProject")).to(DeleteProjectCapability.class);
        this.bind(CapabilityDefinition.class).annotatedWith((Annotation)Exports.named((String)"deleteOwnProject")).to(DeleteOwnProjectCapability.class);
        this.bind(DatabaseDeleteHandler.class).to(this.registerDatabaseHandler());
        this.bind(FilesystemDeleteHandler.class);
        this.bind(ProjectConfigDeleteHandler.class);
        this.install((com.google.inject.Module)new RestApiModule(){

            protected void configure() {
                this.delete(ProjectResource.PROJECT_KIND).to(DeleteProject.class);
                this.post(ProjectResource.PROJECT_KIND, "delete").to(DeleteAction.class);
            }
        });
    }

    private Class<? extends DatabaseDeleteHandler> registerDatabaseHandler() {
        Class databaseDeleteHandlerClass = null;
        int schemaVersion = SchemaVersion.guessVersion((Class)SchemaVersion.C);
        if (schemaVersion < 73) {
            throw new RuntimeException("The delete-project plugin is not compatible with your current schema version (Version: " + schemaVersion + ").");
        }
        databaseDeleteHandlerClass = schemaVersion < 77 ? Schema73DatabaseDeleteHandler.class : Schema77DatabaseDeleteHandler.class;
        assert (databaseDeleteHandlerClass != null) : "No database handler set";
        return databaseDeleteHandlerClass;
    }
}

